% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generated_client.R
\name{credentials_put}
\alias{credentials_put}
\title{Update an existing credential}
\usage{
credentials_put(id, type, username, password, name = NULL,
  description = NULL, remote_host_id = NULL, state = NULL,
  system_credential = NULL)
}
\arguments{
\item{id}{integer required. The ID of the credential.}

\item{type}{string required.}

\item{username}{string required. The username for the credential.}

\item{password}{string required. The password for the credential.}

\item{name}{string optional. The name identifying the credential.}

\item{description}{string optional. A long description of the credential.}

\item{remote_host_id}{integer optional. The ID of the remote host associated with the credential.}

\item{state}{string optional. The U.S. state for the credential. Only for VAN credentials.}

\item{system_credential}{boolean optional.}
}
\value{
A list containing the following elements:
\item{id}{integer, The ID of the credential.}
\item{name}{string, The name identifying the credential}
\item{type}{string, The credential's type.}
\item{username}{string, The username for the credential.}
\item{description}{string, A long description of the credential.}
\item{owner}{string, The name of the user who this credential belongs to.}
\item{remoteHostId}{integer, The ID of the remote host associated with this credential.}
\item{remoteHostName}{string, The name of the remote host associated with this credential.}
\item{state}{string, The U.S. state for the credential. Only for VAN credentials.}
\item{createdAt}{string, The creation time for this credential.}
\item{updatedAt}{string, The last modification time for this credential.}
}
\description{
Update an existing credential
}
