% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cell-geom.R
\name{ccRect}
\alias{ccRect}
\title{Draw rectangle in a region}
\usage{
ccRect(xleft = NULL, ybottom = NULL, xright = NULL, ytop = NULL, rot = 0, ...)
}
\arguments{
\item{xleft}{x for the left bottom points}

\item{ybottom}{y for the left bottom points}

\item{xright}{x for the right top points}

\item{ytop}{y for the right top points}

\item{rot}{Rotation of the rectangles. The value is measured clockwise in degree. Rotation is relative to the center of the rectangles.}

\item{...}{pass to \code{\link[graphics]{polygon}}}
}
\value{
Object \linkS4class{ccCellGeom}
}
\description{
Object \linkS4class{ccCellGeom} will call the function \link[circlize:circos.rect]{circlize::circos.rect} while drawing.
}
\examples{
library(circlizePlus)
cc <- ccPlot(sectors = letters[1:8], xlim = c(0, 1))
track <- ccTrack(ylim = c(0, 1), track.height = 0.3)
cell <- ccCell(sector.index = "a") + ccRect(xleft = 0.7, ybottom = 0.1, xright = 0.8, ytop = 0.9)
track <- track + cell
cc + track
}
