% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cinaR.R
\name{normalizeConsensus}
\alias{normalizeConsensus}
\title{normalizeConsensus}
\usage{
normalizeConsensus(cp, norm.method = "cpm", log.option = FALSE)
}
\arguments{
\item{cp}{bed formatted consensus peak matrix: CHR, START, STOP and raw peak counts (peaks by 3+samples)}

\item{norm.method}{normalization method for consensus peaks}

\item{log.option}{logical, log option for cpm function in edgeR}
}
\value{
Normalized consensus peaks
}
\description{
Normalizes consensus peak using different methods
}
\examples{

set.seed(123)
cp <- matrix(rexp(200, rate=.1), ncol=20)

## using cpm function from `edgeR` package
cp.normalized <- normalizeConsensus(cp)

## quantile normalization option
cp.normalized <- normalizeConsensus(cp, norm.method = "quantile")
}
