% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util.r
\name{cimis_format_location}
\alias{cimis_format_location}
\title{Format CIMIS Station Location}
\usage{
cimis_format_location(d, format = c("DD", "HMS"))
}
\arguments{
\item{d}{A data frame of CIMIS data results.}

\item{format}{The format to use, either Decimal Degrees (\code{"DD"})
or Hour Minutes Seconds (\code{"HMS"}).}
}
\value{
The data frame, with a new \code{"Latitude"} and \code{"Longitude"}
columns replacing the \code{"HmsLatitude"} and \code{"HmsLongitude"}
columns.
}
\description{
Format the latitude and longitude of station in
Decimal Degrees (DD) or Hour Minutes Seconds (HMS).
}
\examples{
if(is_key_set()) {
  d = cimis_station(170)
  cimis_format_location(d, "DD")
  cimis_format_location(d, "HMS")
} 

}
