% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load_surf.R
\name{load_surf}
\alias{load_surf}
\title{Load a \code{"surf"} included in \code{ciftiTools}}
\usage{
load_surf(
  hemisphere = c("left", "right"),
  name = c("inflated", "very inflated", "midthickness"),
  resamp_res = NULL
)
}
\arguments{
\item{hemisphere}{\code{"left"} (default) or \code{"right"}}

\item{name}{The name of the surface geometry to load: \code{"inflated"}
(default), \code{"very inflated"}, and \code{"midthickness"}.}

\item{resamp_res}{The resolution to resample the surfaces to. If \code{NULL}
(default) or 32492, do not resample. Note that the barycentric resampling
method, which is recommended for anatomical surfaces, will be used.}
}
\value{
The \code{"surf"} object
}
\description{
Load a \code{"surf"} object from one of the three 32k anatomical surfaces
included in \code{ciftiTools}.
}
\details{
The surfaces are from the HCP and are included according to these data use
terms: Data were provided [in part] by the Human Connectome Project,
WU-Minn Consortium (Principal Investigators: David Van Essen and Kamil
Ugurbil; 1U54MH091657) funded by the 16 NIH Institutes and Centers
that support the NIH Blueprint for Neuroscience Research; and by the
McDonnell Center for Systems Neuroscience at Washington University.
}
\seealso{
Other functions for reading in CIFTI or GIFTI data: 
\code{\link{as.xifti}()},
\code{\link{info_cifti}()},
\code{\link{load_parc}()},
\code{\link{read_cifti}()},
\code{\link{read_surf}()},
\code{\link{read_xifti2}()}
}
\concept{reading}
