% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write.R
\name{write_csv_chunkwise}
\alias{write_csv_chunkwise}
\alias{write_csv2_chunkwise}
\alias{write_table_chunkwise}
\title{Write chunks to a csv file}
\usage{
write_csv_chunkwise(x, file = "", sep = ",", dec = ".",
  col.names = TRUE, row.names = FALSE, ...)

write_csv2_chunkwise(x, file = "", sep = ";", dec = ",",
  col.names = TRUE, row.names = FALSE, ...)

write_table_chunkwise(x, file = "", sep = "\\t", dec = ".",
  col.names = TRUE, row.names = TRUE, ...)
}
\arguments{
\item{x}{chunkwise object pointing to a text file}

\item{file}{file \code{character} or connection where the csv file should be written}

\item{sep}{field separator}

\item{dec}{decimal separator}

\item{col.names}{should column names be written?}

\item{row.names}{should row names be written?}

\item{...}{passed through to \code{\link{read.table}}}
}
\value{
chunkwise object (chunkwise), when writing to a file it refers to the
newly created file, otherwise to \code{x}.
}
\description{
Writes data to a csv file chunk by chunk. This function must be just in
conjunction with \code{\link{read_csv_chunkwise}}. Chunks of data will
be read, processed and written when this function is called.
For writing to a database use \code{\link{insert_chunkwise_into}}.
}
\examples{
# create csv file for demo purpose
in_file <- file.path(tempdir(), "in.csv")
write.csv(women, in_file, row.names = FALSE, quote = FALSE)

#
women_chunked <-
  read_chunkwise(in_file) \%>\%  #open chunkwise connection
  mutate(ratio = weight/height) \%>\%
  filter(ratio > 2) \%>\%
  select(height, ratio) \%>\%
  inner_join(data.frame(height=63:66)) # you can join with data.frames!

# no processing done until
out_file <- file.path(tempdir(), "processed.csv")
women_chunked \%>\%
  write_chunkwise(file=out_file)

head(women_chunked) # works (without processing all data...)

iris_file <- file.path(tempdir(), "iris.csv")
write.csv(iris, iris_file, row.names = FALSE, quote= FALSE)

iris_chunked <-
  read_chunkwise(iris_file, chunk_size = 49) \%>\% # 49 for demo purpose
  group_by(Species) \%>\%
  summarise(sepal_length = mean(Sepal.Length), n=n()) # note that mean is per chunk

}
