% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/manage.R
\name{chrome_versions_list}
\alias{chrome_versions_list}
\title{List installed or available Chrome binary versions}
\usage{
chrome_versions_list(
  which = c("installed", "all"),
  binary = c("all", "chrome", "chrome-headless-shell", "chromedriver"),
  platform = NULL
)
}
\arguments{
\item{which}{Whether to list \code{"installed"} local binaries or to list \code{"all"}
chrome versions available from online sources.}

\item{binary}{A character string specifying which binary to list. Defaults to
\code{"all"} to show all binaries, or can be one or more of of \code{"chrome"},
\code{"chrome-headless-shell"}, or \code{"chromedriver"}.}

\item{platform}{A character string specifying the platform(s) to list. If
\code{NULL} (default), the platform will be automatically detected, or if
\code{"all"}, then binaries for all platforms will be listed.}
}
\value{
Returns a \code{\link[=data.frame]{data.frame()}} of Chrome for Testing versions with
columns: \code{version}, \code{revision}, \code{binary}, \code{platform}, \code{url} (where the
binary can be downloaded), and--if \code{which = "installed"}--the local path to
the binary in the \code{\link[=chrome_versions_path_cache]{chrome_versions_path_cache()}}.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#Experimental}{\figure{lifecycle-experimental.svg}{options: alt='[E]'}}}{\strong{[E]}}

By default lists the installed Chrome versions in the \code{\link[=chrome_versions_path_cache]{chrome_versions_path_cache()}},
or list all Chrome versions available via Google's
\href{https://googlechromelabs.github.io/chrome-for-testing/}{Chrome for Testing}
service.

Managed Chrome installations is an experimental feature introduced in
chromote v0.5.0 and was inspired by similar features in
\href{https://playwright.dev/}{playwright}.
}
\examples{
\dontshow{if (rlang::is_interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
chrome_versions_list()
\dontshow{\}) # examplesIf}
}
