% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{calculate_percent_change}
\alias{calculate_percent_change}
\title{Calculate the percentage change between two choroplethr dataframes.}
\usage{
calculate_percent_change(df1, df2)
}
\arguments{
\item{df1}{A dataframe with columns named "region" and "value"}

\item{df2}{A dataframe with columns named "region" and "value"}
}
\description{
Merges df1 and df2 on column named "region", and computes percentage change from
df1$value to df2$value. Result is in the new "value" column, and rounded to two
digits.
}
\examples{
\dontrun{
# load median age estimates from 2010 and 2015
data(df_state_age_2010)
data(df_state_age_2015)

df_age_diff = calculate_percent_change(df_state_age_2010, df_state_age_2015)
state_choropleth(df_age_diff, 
    title      = "Percent Change in Median Age, 2010-2015", 
    legend     = "Percent Change", 
    num_colors = 0)
}
}
