% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rbind.R
\name{check_rbind}
\alias{check_rbind}
\title{Check Row Bind}
\usage{
check_rbind(x, y, exclusive = TRUE, order = FALSE,
  x_name = substitute(x), y_name = substitute(y), error = TRUE)
}
\arguments{
\item{x}{The first data frame.}

\item{y}{The second data frame.}

\item{exclusive}{A flag indicating whether other columns are not permitted.}

\item{order}{A flag indicating whether the columns have to occur in the same order.}

\item{x_name}{A string of the name of the object x.}

\item{y_name}{A string of the name of the object y.}

\item{error}{A flag indicating whether to throw an informative error or immediately generate an informative message if the check fails.}
}
\value{
An invisible copy of x (if it doesn't throw an error).
}
\description{
Checks whether a data frame has the same columns of the same classes as a second data frame which means they can be \code{\link{rbind}}ed without a problem.
}
\examples{
check_rbind(datasets::mtcars, datasets::mtcars)
}
\seealso{
\code{\link{check_join}}
}
