% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setSnapshot.R
\name{setSnapshot}
\alias{setSnapshot}
\title{Set default CRAN repository to MRAN snapshot date.}
\usage{
setSnapshot(snapshotDate, online = TRUE)
}
\arguments{
\item{snapshotDate}{Date of snapshot to use in \code{YYYY-MM-DD} format, e.g. \code{"2014-09-17"}.  Specify a date on or after \code{"2014-09-17"}.  MRAN takes one snapshot per day. To list all valid snapshot dates on MRAN use \code{\link[=getValidSnapshots]{getValidSnapshots()}}}

\item{online}{If TRUE, performs online validation checks. This can be set to FALSE for programming purposes. Internally, \code{\link[=checkpoint]{checkpoint()}} sets this value to FALSE when not scanning for packages.}
}
\description{
Set default CRAN repository to MRAN snapshot date.
}
\examples{
# Empty date field returns current repo

oldRepos <- getOption("repos")
setSnapshot()

# Valid snapshot date
# Connects to MRAN to check for valid URL, so skip on CRAN
\dontrun{
setSnapshot("2014-11-16")
}

# Invalid snapshot date (in future), returns error
\dontrun{
setSnapshot("2100-01-01")
}

options(repos = oldRepos)
}
\seealso{
Other checkpoint functions: \code{\link{checkpointArchives}},
  \code{\link{checkpointRemove}}, \code{\link{checkpoint}},
  \code{\link{getAccessDate}},
  \code{\link{getValidSnapshots}}, \code{\link{mranUrl}},
  \code{\link{unCheckpoint}}
}
