% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/checkNamed.r
\name{checkNamed}
\alias{assertNamed}
\alias{checkNamed}
\alias{testNamed}
\title{Check if an argument is named}
\usage{
checkNamed(x, type = "named")

assertNamed(x, type = "named", .var.name)

testNamed(x, type = "named")
}
\arguments{
\item{x}{[any]\cr
Object to check.}

\item{type}{[character(1)]\cr
Select the check(s) to perform.
\dQuote{unnamed} checks \code{x} to be unnamed.
\dQuote{named} (default) checks \code{x} to be named which excludes names to be \code{NA} or emtpy (\code{""}).
\dQuote{unique} additionally tests for non-duplicated names.
\dQuote{strict} checks for unique names which comply to R's variable name restrictions.
Note that for zero-length \code{x} every name check evalutes to \code{TRUE}.
Also note that you can use \code{\link{checkSubset}} to check for a specific set of names.}

\item{.var.name}{[character(1)]\cr
Name for \code{x}. Defaults to a heuristic to determine
the name using \code{\link[base]{deparse}} and \code{\link[base]{substitute}}.}
}
\value{
Depending on the function prefix:
 If the check is successful, all functions return \code{TRUE}.
 If the check is not successful, \code{assertNamed} throws an error message,
 \code{testNamed} returns \code{FALSE}, \code{checkNamed} returns
 a string with the error message. The function \code{expect_named} will
 return an \code{\link[testthat]{expectation}}.
}
\description{
Check if an argument is named
}
\examples{
x = 1:3
testNamed(x, "unnamed")
names(x) = letters[1:3]
testNamed(x, "unique")
}

