% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ch_list_globals.R
\name{print_globals}
\alias{print_globals}
\title{Print no visible globals from check and separate by category}
\usage{
print_globals(globals, path = ".", ..., message = TRUE)
}
\arguments{
\item{globals}{A list as issued from \code{\link{get_no_visible}} or empty}

\item{path}{Path to a package tarball or a directory.}

\item{...}{Other parameters for \code{\link[rcmdcheck]{rcmdcheck}}}

\item{message}{Logical. Whether to return message with content (Default) or return as list}
}
\value{
A message with no visible globals or a list with no visible globals
}
\description{
Print no visible globals from check and separate by category
}
\examples{
\dontrun{
# This runs a check of the example package
tempdir <- tempdir()
# Create fake package
usethis::create_package(file.path(tempdir, "checkpackage"), open = FALSE)

# Create function no visible global variables and missing documented functions
cat("
#' Function
#' @importFrom dplyr filter
#' @export
my_fun <- function() {
data \%>\%
ggplot2::ggplot() +
  aes(x, y, colour = new_col) +
  geom_point()
}
", file = file.path(tempdir, "checkpackage", "R", "function.R"))

path <- file.path(tempdir, "checkpackage")
attachment::att_to_description(path = path)
globals <- get_no_visible(path)
print_globals(globals = globals)
}
}
