% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/internal.R
\name{approx_gradient}
\alias{approx_gradient}
\title{Approximate Gradient}
\usage{
approx_gradient(graph, target, node, index = 1, eps = 1e-04)
}
\arguments{
\item{graph}{cg_graph object, graph that is differentiated.}

\item{target}{cg_node object, node in the graph that is differentiated.}

\item{node}{cg_node object, node with respect to which the target node is differentiated.}

\item{index}{numeric scalar, index of the target node that is differentiated. Defaults to the first element.}

\item{eps}{numeric scalar, step size. Defaults to 1e-4.}
}
\value{
the derivative of the node supplied to argument \code{node} with respect to the node supplied to argument \code{target}.
}
\description{
Differentiate a target node with respect to a given node by numerical differentiation.
}
\note{
All nodes required to compute the target node must have a value or their value must be able to be computed at run-time. Only those nodes needed to compute the target node (including the target itself) are evaluated.

The graph is differentiation by the symmetric difference quotient. This method can only be used to differentiate scalars. In case the target node evaluates to a vector or an array, argument \code{index} can be used to specify which element of the vector or array is differentiated. The derivative has the same shape as the value of node supplied to argument \code{node}.

Numerical differentiation is subject to estimation error and can be very slow. Therefore, this function should only be used for testing purposes.
}
\author{
Ron Triepels
}
\keyword{internal}
