% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepare_data.R
\name{prepare_data}
\alias{prepare_data}
\alias{prepare_data.incidence2}
\title{Prepare common epidemiological data formats for CFR estimation}
\usage{
prepare_data(data, ...)

\method{prepare_data}{incidence2}(
  data,
  cases_variable = "cases",
  deaths_variable = "deaths",
  fill_NA = TRUE,
  ...
)
}
\arguments{
\item{data}{A \verb{<data.frame>}-like object. Currently, only \verb{<incidence2>}
objects are supported. These may be grouped.}

\item{...}{Currently unused. Passing extra arguments will throw a warning.}

\item{cases_variable}{A string for the name of the cases variable in the
"count_variable" column of \code{data}.}

\item{deaths_variable}{A string for the name of the deaths variable in the
"count_variable" column of \code{data}.}

\item{fill_NA}{A logical indicating whether \code{NA}s in the cases and deaths
data should be replaced by 0s. The default value is \code{TRUE}, with a message
to make users aware of the replacement.}
}
\value{
A \verb{<data.frame>} suitable for disease severity estimation functions
provided in \pkg{cfr}, with the columns "date", "cases", and "deaths".

Additionally, for grouped \verb{<incidence2>} data, columns representing the
grouping variables will also be present.

The result has a continuous sequence of dates between the start and end date
of \code{data}; this is required if the data is to be passed to functions such as
\code{\link[=cfr_static]{cfr_static()}}.
}
\description{
This S3 generic has methods for classes commonly used for epidemiological
data.

Currently, the only supported data format is \verb{<incidence2>} from the
\pkg{incidence2} package. See \code{\link[incidence2:incidence]{incidence2::incidence()}}. Grouped
\verb{<incidence2>} data are supported, see \strong{Details}.
}
\details{
The method for \verb{<incidence2>} data can replace \code{NA}s in the case and death
data with 0s using the \code{fill_NA} argument, which is \code{TRUE} by default,
meaning that \code{NA}s are replaced.

Keeping \code{NA}s will cause downstream issues when calling functions such as
\code{\link[=cfr_static]{cfr_static()}} on the data, as they cannot handle \code{NA}s.
Setting \code{fill_NA = TRUE} resolves this issue.

Passing a grouped \verb{<incidence2>} object to \code{data} will result in the function
respecting the grouping and returning grouping variables in separate columns.
}
\examples{
#### For <incidence2> data ####
# load Covid-19 data from incidence2
covid_uk <- incidence2::covidregionaldataUK

# convert to incidence2 object
covid_uk_incidence <- incidence2::incidence(
  covid_uk,
  date_index = "date",
  counts = c("cases_new", "deaths_new"),
  count_names_to = "count_variable"
)

# View tail of prepared data
data <- prepare_data(
  covid_uk_incidence,
  cases_variable = "cases_new",
  deaths_variable = "deaths_new"
)

tail(data)

#### For grouped <incidence2> data ####
# convert data to incidence2 object grouped by region
covid_uk_incidence <- incidence2::incidence(
  covid_uk,
  date_index = "date",
  counts = c("cases_new", "deaths_new"),
  count_names_to = "count_variable",
  groups = "region"
)

# View tail of prepared data
data <- prepare_data(
  covid_uk_incidence,
  cases_variable = "cases_new",
  deaths_variable = "deaths_new"
)

tail(data)

}
