% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_outcomes.R
\name{estimate_outcomes}
\alias{estimate_outcomes}
\title{Estimate known outcomes of cases using a delay distribution}
\usage{
estimate_outcomes(data, delay_density)
}
\arguments{
\item{data}{A \verb{<data.frame>} containing the outbreak data. A daily time
series with dates or some other absolute indicator of time (e.g. epiday or
epiweek) and the numbers of new cases and new deaths at each time point.
Note that the required columns are "date" (for the date), "cases" (for the
number of reported cases), and "deaths" (for the number of reported deaths)
on each day of the outbreak.

Note that the \verb{<data.frame>} is required to have an unbroken sequence of
dates with no missing dates in between. The "date" column must be of class
\code{Date} (see \code{\link[=as.Date]{as.Date()}}).

Note also that the total number of cases must be greater than the total
number of reported deaths.}

\item{delay_density}{An optional argument that controls whether delay
correction is applied in the severity estimation.
May be \code{NULL}, for no delay correction, or a function that returns the
density function of a distribution to evaluate
density at user-specified values, e.g.
\code{function(x) stats::dgamma(x = x, shape = 5, scale = 1)}.}
}
\value{
A \verb{<data.frame>} with the columns in \code{data}, and with two additional
columns:
\itemize{
\item \code{"estimated_outcomes"} for the number of cases with an outcome of interest
(usually, death) estimated to be known on the dates specified in \code{data}, and
\item \code{"u_t"} for the ratio of cumulative number of estimated known outcomes
and the cumulative number of cases reported until each date specified in
\code{data}.
}
}
\description{
Estimates the expected number of individuals with known outcomes
from a case and outcome time series of outbreak data, and an epidemiological
delay distribution of symptom onset to outcome.
When calculating a case fatality risk, the outcomes must be deaths, the delay
distribution must be an onset-to-death distribution, and the function returns
estimates of the known death outcomes.
}
\examples{
# Load Ebola 1976 outbreak data
data("ebola1976")

# estimate severity for each day while correcting for delays
# obtain onset-to-death delay distribution parameters from Barry et al. 2018
# examine the first few rows of the output
estimated_outcomes <- estimate_outcomes(
  data = ebola1976,
  delay_density = function(x) dgamma(x, shape = 2.40, scale = 3.33)
)

head(estimated_outcomes)
}
