% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_ascertainment.R
\name{estimate_ascertainment}
\alias{estimate_ascertainment}
\title{Estimate the ascertainment ratio of a disease}
\usage{
estimate_ascertainment(data, severity_baseline, delay_density = NULL)
}
\arguments{
\item{data}{A \verb{<data.frame>} containing the outbreak data. A daily time
series with dates or some other absolute indicator of time (e.g. epiday or
epiweek) and the numbers of new cases and new deaths at each time point.
Note that the required columns are "date" (for the date), "cases" (for the
number of reported cases), and "deaths" (for the number of reported deaths)
on each day of the outbreak.

Note that the \verb{<data.frame>} is required to have an unbroken sequence of
dates with no missing dates in between. The "date" column must be of class
\code{Date} (see \code{\link[=as.Date]{as.Date()}}).

Note also that the total number of cases must be greater than the total
number of reported deaths.}

\item{severity_baseline}{A single number in the range 0.0 -- 1.0 for the
assumed true baseline severity estimate used to estimate the overall
ascertainment ratio. Missing by default, which causes the function to error;
must be supplied by the user.}

\item{delay_density}{An optional argument that controls whether delay
correction is applied in the severity estimation.
May be \code{NULL}, for no delay correction, or a function that returns the
density function of a distribution to evaluate
density at user-specified values, e.g.
\code{function(x) stats::dgamma(x = x, shape = 5, scale = 1)}.}
}
\value{
A \verb{<data.frame>} containing the maximum likelihood estimate estimate
and 95\% confidence interval of the corrected severity, named
"ascertainment_mean" (for the central estimate), and "ascertainment_low" and
"ascertainment_high" for the lower and upper interval limits.
}
\description{
Estimates the proportion of cases or infections that have been
ascertained, given a time-series of cases and deaths, a delay distribution
and a baseline severity estimate. The resulting ascertainment estimate is
calculated as the ratio of the baseline severity estimate, which is assumed
to be the 'true' disease severity, and the delay-adjusted severity estimate.
}
\examples{
# get data pre-loaded with the package
data("covid_data")
df_covid_uk <- covid_data[covid_data$country == "United Kingdom", ]

df_covid_uk_subset <- subset(df_covid_uk, date <= "2020-05-31")

# use a severity baseline of 1.4\% (0.014) taken from Verity et al. (2020)
# Lancet Infectious Diseases: <https://doi.org/10.1016/S1473-3099(20)30243-7>

# use onset-to-death distribution from Linton et al. (2020)
# J. Clinical Medicine: <https://doi.org/10.3390/jcm9020538>

# subset data until 30th June 2020
data <- df_covid_uk[df_covid_uk$date <= "2020-06-30", ]
estimate_ascertainment(
  data = data,
  delay_density = function(x) dlnorm(x, meanlog = 2.577, sdlog = 0.440),
  severity_baseline = 0.014
)

}
