% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cff.R
\name{cff}
\alias{cff}
\title{Create \code{\link{cff}} objects from direct inputs}
\usage{
cff(path, ...)
}
\arguments{
\item{path}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} \code{path} is no longer supported,
use \code{\link[=cff_read_cff_citation]{cff_read_cff_citation()}} instead.}

\item{...}{Named arguments to be used for creating a \code{cff} object. If no
arguments are supplied (the default behavior), a minimal valid \code{cff}
object is created.}
}
\value{
A \code{\link{cff}} object. Under the hood, a \code{cff} object is a regular \code{\link{list}}
object with a special \code{\link[=print.cff]{print}} method.
}
\description{
A class and utility methods for reading, creating and holding CFF
information. See \link{cff_class} to learn more about \code{cff} objects.
}
\details{
\code{cff()} would convert \verb{_} in the name of the argument to \code{-}, e.g.
\verb{cff_version = "1.2.0'} would be converted to \verb{cff-version = "1.2.0'}.

Valid parameters are those specified on \code{\link[=cff_schema_keys]{cff_schema_keys()}}:
\itemize{
\item \code{cff-version}
\item \code{message}
\item \code{type}
\item \code{license}
\item \code{title}
\item \code{version}
\item \code{doi}
\item \code{identifiers}
\item \code{abstract}
\item \code{authors}
\item \code{preferred-citation}
\item \code{repository}
\item \code{repository-artifact}
\item \code{repository-code}
\item \code{commit}
\item \code{url}
\item \code{date-released}
\item \code{contact}
\item \code{keywords}
\item \code{references}
\item \code{license-url}
}
}
\examples{
# Blank cff
cff()

# Use custom params
test <- cff(
  title = "Manipulating files",
  keywords = c("A", "new", "list", "of", "keywords"),
  authors = as_cff_person("New author")
)
test
\donttest{
# Would fail
cff_validate(test)
}

# Modify with cff_create
new <- cff_create(test, keys = list(
  "cff_version" = "1.2.0",
  message = "A blank file"
))
new

# Would pass
cff_validate(new)

}
\seealso{
Other core functions of \CRANpkg{cffr}:
\code{\link{cff_create}()},
\code{\link{cff_modify}()},
\code{\link{cff_validate}()}
}
\concept{core}
