% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cff_read.R
\name{cff_read}
\alias{cff_read}
\alias{cff}
\alias{as.cff}
\title{Read and manipulate \code{cff} objects}
\usage{
cff_read(path)

cff(path, ...)

as.cff(x)
}
\arguments{
\item{path}{The path to a \code{CITATION.cff} file.}

\item{...}{Named arguments to be used for creating a \code{\link{cff}} object. See
\strong{Details}.}

\item{x}{a character string for the \code{\link{as.cff}} default method}
}
\value{
A \code{cff} object. Under the hood, a \code{cff} object is a regular \code{\link{list}} object
with a special \code{\link[=print]{print()}} method.
}
\description{
A class and utility methods for reading, creating and holding CFF
information.
}
\details{
This object can be manipulated using \code{\link[=cff_create]{cff_create()}}.

\strong{Note that} this function reads \code{CITATION.cff} files. If you want to
create \code{cff} objects from DESCRIPTION files use \code{\link[=cff_create]{cff_create()}}.

If no additional \code{...} parameters are supplied (the default behavior),
a minimal valid \code{cff} object is created. Valid parameters are those
specified on \code{\link[=cff_schema_keys]{cff_schema_keys()}}:\tabular{l}{
   \strong{valid cff keys} \cr
   cff-version \cr
   message \cr
   type \cr
   license \cr
   title \cr
   version \cr
   doi \cr
   abstract \cr
   authors \cr
   preferred-citation \cr
   repository \cr
   repository-artifact \cr
   repository-code \cr
   url \cr
   date-released \cr
   contact \cr
   keywords \cr
   references \cr
   commit \cr
   identifiers \cr
   license-url \cr
}
}
\examples{

# Blank cff
cff()

# From file
cff_read(system.file("examples/CITATION_basic.cff",
  package = "cffr"
))

# Use custom params
test <- cff(
  title = "Manipulating files",
  keywords = c("A", "new", "list", "of", "keywords"),
  authors = list(cff_parse_person("New author"))
)
test
\donttest{
# Would fail
cff_validate(test)


# Modify with cff_create
new <- cff_create(test, keys = list(
  "cff-version" = "1.2.0",
  message = "A blank file"
))
new

# Would pass
cff_validate(new)
}


# Convert a list to "cff" object
cffobj <- as.cff(list(
  "cff-version" = "1.2.0",
  title = "Manipulating files"
))

class(cffobj)

# Nice display thanks to yaml package
cffobj
}
\seealso{
Other core functions: 
\code{\link{cff_create}()},
\code{\link{cff_validate}()},
\code{\link{cff_write}()}
}
\concept{core functions}
