% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cff_from_bibtex.R
\name{cff_from_bibtex}
\alias{cff_from_bibtex}
\title{Create a cff object from BibTeX entries}
\usage{
cff_from_bibtex(x, encoding = "UTF-8", ...)
}
\arguments{
\item{x}{The source that would be used for generating the \code{cff} object. A
\code{character} object indicating either:
\itemize{
\item The path to a BibTeX file.
\item A vector of characters with the full BibTeX string. See \strong{Examples}
}}

\item{encoding}{Encoding to be assumed for \code{x}. See \code{\link[=readLines]{readLines()}}.}

\item{...}{Other arguments passed to \code{\link[bibtex:read.bib]{bibtex::read.bib()}}.}
}
\value{
A \code{\link{cff}} object ready to be used on \code{\link[=cff_create]{cff_create()}}.
}
\description{
Extract the information of a BibTeX file or BibTeX entry and creates the
corresponding \code{\link{cff}} object with \code{\link[=cff_parse_citation]{cff_parse_citation()}}.
}
\details{
This function requires the package \strong{bibtex} (>= 0.5.0), that is listed
as \code{Suggested} by  \strong{cffr}.
}
\examples{
if (requireNamespace("bibtex", quietly = TRUE)) {
  x <- c(
    "@book{einstein1921,
    title        = {Relativity: The Special and the General Theory},
    author       = {Einstein, Albert},
    year         = 1920,
    publisher    = {Henry Holt and Company},
    address      = {London, United Kingdom},
    isbn         = 9781587340925
}",
    "@misc{misc-full,
    title        = {Handing out random pamphlets in airports},
    author       = {Joe-Bob Missilany},
    year         = 1984,
    month        = oct,
    note         = {This is a full MISC entry},
    howpublished = {Handed out at O'Hare}
}"
  )

  cff_from_bibtex(x)

  # From a file

  x2 <- system.file("examples/example.bib", package = "cffr")
  cff_from_bibtex(x2)
}
}
\seealso{
\code{vignette("bibtex_cff", package = "cffr")} to learn about the mapping of
information between BibTeX and CITATION.cff.

Other bibtex: 
\code{\link{cff_extract_to_bibtex}()},
\code{\link{cff_to_bibtex}()},
\code{\link{encoded_utf_to_latex}()},
\code{\link{write_bib}()}
}
\concept{bibtex}
