% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cff_create.R
\name{cff_create}
\alias{cff_create}
\title{Create \code{cff} object}
\usage{
cff_create(
  x,
  keys = list(),
  cff_version = "1.2.0",
  gh_keywords = TRUE,
  dependencies = TRUE
)
}
\arguments{
\item{x}{The source that would be used for generating
the \code{\link{cff}} object. It could be:
\itemize{
\item A missing value. That would retrieve the DESCRIPTION
file on your in-development package.
\item An existing \code{\link{cff}} object,
\item The name of an installed package (\code{"jsonlite"}), or
\item Path to a DESCRIPTION file (\code{"*/DESCRIPTION*"}).
}}

\item{keys}{List of additional keys to add to the \code{\link{cff}} object. See
\strong{Details}.}

\item{cff_version}{The Citation File Format schema version that the
\code{CITATION.cff} file adheres to for providing the citation metadata.}

\item{gh_keywords}{Logical \code{TRUE/FALSE}. If the package is hosted on
GitHub, would you like to add the repo topics as keywords?}

\item{dependencies}{Logical \code{TRUE/FALSE}. Would you like to add the
of your package to the \code{reference} key?}
}
\value{
A \code{\link{cff}} list object.
}
\description{
Create a \code{\link{cff}} object from a given source for further manipulation.
Similar to \code{\link[=cff_write]{cff_write()}}, but returns a object rather than writing
directly to a file. See \strong{Examples}.
}
\details{
It is possible to add additional keys not detected by \code{\link[=cff_create]{cff_create()}} using
the \code{keys} argument. A list of valid keys can be retrieved with
\code{\link[=cff_schema_keys]{cff_schema_keys()}}.

Please refer to
\href{https://github.com/citation-file-format/citation-file-format/blob/main/schema-guide.md}{Guide to Citation File Format schema version 1.2.0}.
for additional details.

If \code{x} is a path to a DESCRIPTION file or \code{inst/CITATION}, is not present on
your package, \strong{cffr} would auto-generate a \code{preferred-citation} key using
the information provided on that file. On
}
\examples{
\donttest{
# Installed package
cff_create("jsonlite")

# Demo file
demo_file <- system.file("examples/DESCRIPTION_basic", package = "cffr")
cff_create(demo_file)

# Add additional keys

newkeys <- list(
  message = "This overwrites fields",
  abstract = "New abstract",
  keywords = c("A", "new", "list", "of", "keywords"),
  authors = list(cff_parse_person("New author"))
)

cff_create(demo_file, keys = newkeys)

# Update a field on a list - i,e: authors, contacts, etc.
# We are adding a new contact here

old <- cff_create(demo_file)

new_contact <- append(
  old$contact,
  list(
    cff_parse_person(person(
      given = "I am",
      family = "New Contact"
    ))
  )
)


cff_create(demo_file, keys = list("contact" = new_contact))
}
}
\seealso{
\href{https://github.com/citation-file-format/citation-file-format/blob/main/schema-guide.md}{Guide to Citation File Format schema version 1.2.0}.

\code{vignette("cffr", "cffr")}

Other core functions: 
\code{\link{cff_validate}()},
\code{\link{cff_write}()},
\code{\link{cff}()}
}
\concept{core functions}
