% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cff_parse_citation.R
\name{cff_parse_citation}
\alias{cff_parse_citation}
\title{Parse a \code{bibentry} to \code{cff}}
\usage{
cff_parse_citation(bib)
}
\arguments{
\item{bib}{A \code{bibentry} object, either created with \code{\link[utils:citation]{utils::citation()}} or
with \code{\link[utils:bibentry]{utils::bibentry()}}.}
}
\value{
A \code{\link{cff}} object ready to be used on \code{\link[=cff_create]{cff_create()}}.
}
\description{
Parse a \code{bibentry} object to a valid format for a \code{CITATION.cff} file.
}
\details{
This is a helper function designed to help on adding or
replacing the auto-generated authors of the package. See \strong{Examples}.
}
\examples{
\donttest{
bib <- citation("base")
bib


# To cff
bib_to_cff <- cff_parse_citation(bib)
bib_to_cff

# Create the object
new_cff <- cff()

full <- cff_create(new_cff, keys = list("preferred-citation" = bib_to_cff))

full
# Validate
cff_validate(full)

# Several citations

cff_parse_citation(citation("rmarkdown"))
}
}
\seealso{
\code{\link[=cff_create]{cff_create()}}, \code{vignette("cffr", "cffr")}, \code{\link[utils:bibentry]{utils::bibentry()}}

Other parsers: 
\code{\link{cff_parse_person}()}
}
\concept{parsers}
