% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_emigration.R
\name{read_emigration}
\alias{read_emigration}
\title{Download microdata of emigration records from Brazil's census}
\usage{
read_emigration(
  year = 2010,
  columns = NULL,
  add_labels = NULL,
  as_data_frame = FALSE,
  showProgress = TRUE,
  cache = TRUE
)
}
\arguments{
\item{year}{Numeric. Year of reference in the format \code{yyyymm}. Defaults to
\code{2010}.}

\item{columns}{String. A vector of column names to keep. The rest of the
columns are not read. Defaults to \code{NULL} and read all columns.}

\item{add_labels}{Character. Whether the function should add labels to the
responses of categorical variables. When \code{add_labels = "pt"}, the
function adds labels in Portuguese. Defaults to \code{NULL}.}

\item{as_data_frame}{Logical. When \code{FALSE} (Default), the function returns an
Arrow Dataset, which allows users to work with larger-than-memory data.
If \code{TRUE}, the function returns \code{data.frame}.}

\item{showProgress}{Logical. Defaults to \code{TRUE} display download progress
bar. The progress bar only reflects only the downloading
time, not the time to load the data to memory.}

\item{cache}{Logical. Whether the function should read the data cached
locally, which is much faster. Defaults to \code{TRUE}. The first time the
user runs the function, \code{censobr} will download the file and store it
locally so that the file only needs to be download once. If \code{FALSE},
the function will download the data again and overwrite the local file.}
}
\value{
An arrow \code{Dataset} or a \code{"data.frame"} object.
}
\description{
Download microdata of emigration records from Brazil's census. Data collected in
the sample component of the questionnaire.
}
\examples{
\dontshow{if (identical(tolower(Sys.getenv("NOT_CRAN")), "true")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# return data as arrow Dataset
df <- read_emigration(year = 2010)

# return data as data.frame
df <- read_emigration(year = 2010, as_data_frame = TRUE)
\dontshow{\}) # examplesIf}
}
\seealso{
Other Microdata: 
\code{\link{read_families}()},
\code{\link{read_households}()},
\code{\link{read_mortality}()},
\code{\link{read_population}()}
}
\concept{Microdata}
