% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qrBugs.R
\name{qrBugs}
\alias{qrBugs}
\title{Running cdf quantile regression in OpenBUGS}
\usage{
qrBugs(formula, data, fd, sd, bugs = TRUE, random = NULL, nodes = NULL,
  inits = NULL, n.iter = 10000, n.burnin = n.iter/2,
  modelname = "bugmodel", working.directory = NULL, ...)
}
\arguments{
\item{formula}{A formula object, with the DV on the left of an ~ operator, and predictors on the right. For the part on the right of '~', the specification of the submodels can be seperated by '|'. So \code{y ~ X1 | X2} means the DV is \code{y},\code{X1} is the term in the mean submodel, and \code{X2} is the term in the dispersion submodel.}

\item{data}{The data file. Can be either a data.frame or a list of with specifying the names of variable in the list. The structure of the list and list component (e.g., matrix) should follow BUGS data format (see XXX for more details about preparing for list format of the data)}

\item{fd}{A string that specifies the parent distribution.}

\item{sd}{A string that specifies the sub-family distribution.}

\item{bugs}{A logical value to indicate whether to use JAGS or OpenBUGS (NOTE: currently only OpenBUGS supports the customized likelihood functions; the package will update to allow JAGS as soon as JAGS provides that function).}

\item{random}{Character or vector of characters that indicate the random effect factors.}

\item{nodes}{Character or vector of characters that indicate the parameters to be estimated. The default nodes are the coefficients in both the mean and dispersion submodel.}

\item{inits}{A list of values that serve as initial values for MCMC chain procedure.}

\item{n.iter}{The number of MCMC samples to be drawn from the posterior distribution.}

\item{n.burnin}{The number of samples to be discarded when summarizing the MCMC simulation results.}

\item{modelname}{Name of the model (optional).}

\item{working.directory}{the directory for generating temporary BUGS files.}

\item{...}{further arguments to \code{\link[R2OpenBUGS]{bugs}}.}
}
\value{
A bugs object (See more details)
}
\description{
Function used for running cdf quantile regression in OpenBUGS and performing 
Bayesian MCMC estimation.
In addition, a simple random effects model is allowed to be estimated in this function.
}
\examples{
data(cdfqrExampleData)
\dontrun{
# Need to OpenBUGS has been installed, and R2OpenBUGS has been loaded first. 
library(R2OpenBUGS)
bugfit <- qrBugs(crc99 ~ vert | confl, data = JurorData, 't2', 't2',clearWD=TRUE)
bugfit
Inference for Bugs model at "bugmodel.txt", 
# Current: 2 chains, each with 10000 iterations (first 5000 discarded)
# Cumulative: n.sims = 10000 iterations saved
# mean  sd  2.5\%   25\%   50\%   75\% 97.5\% Rhat n.eff
# b_0        0.8 0.1   0.6   0.7   0.8   0.9   1.0    1   830
# d_0       -0.2 0.1  -0.4  -0.3  -0.2  -0.1   0.1    1  1700
# b_vert     0.1 0.1  -0.1   0.0   0.1   0.2   0.3    1   170
# d_confl    0.0 0.1  -0.3  -0.1   0.0   0.0   0.2    1  4000
# deviance -49.3 2.8 -52.8 -51.3 -49.9 -47.9 -42.1    1  7400
# 
# For each parameter, n.eff is a crude measure of effective sample size,
# and Rhat is the potential scale reduction factor (at convergence, Rhat=1).
# 
# DIC info (using the rule, pD = Dbar-Dhat)
# pD = 4.0 and DIC = -45.3
# DIC is an estimate of expected predictive error (lower deviance is better).
}
}
\seealso{
\code{\link[R2OpenBUGS]{bugs}}
}
