% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_flu_data.r
\name{get_flu_data}
\alias{get_flu_data}
\title{Retrieves state, regional or national influenza statistics from the CDC}
\usage{
get_flu_data(region = "hhs", sub_region = 1:10, data_source = "ilinet",
  years = as.numeric(format(Sys.Date(), "\%Y")))
}
\arguments{
\item{region}{one of "\code{hhs}", "\code{census}", "\code{national}"}

\item{sub_region}{depends on the \code{region_type}.\cr
For "\code{national}", the \code{sub_region} should be \code{NA}.\cr
For "\code{hhs}", should be a vector between \code{1:10}.\cr
For "\code{census}", should be a vector between \code{1:9}}

\item{data_source}{either of "\code{who}" (for WHO NREVSS) or "\code{ilinet}"
or "\code{all}" (for both)}

\item{years}{a vector of years to retrieve data for (i.e. \code{2014} for CDC
flu season 2014-2015). Default value is the current year and all
\code{years} values should be > \code{1997}}
}
\value{
If only a single \code{data_source} is specified, then a single
        \code{data.frame} is returned, otherwise a named list with each
        \code{data.frame} is returned.
}
\description{
Uses the data source from the
\href{https://gis.cdc.gov/grasp/fluview/fluportaldashboard.html}{CDC FluView}
and provides flu reporting data as either a single data frame or a list of
data frames (depending on whether either \code{WHO NREVSS} or \code{ILINet}
(or both) is chosen.
}
\details{
A lookup table between HHS regions and their member states/territories
is provided in \code{\link{hhs_regions}}.
}
\note{
There is often a noticeable delay when making the API request to the CDC.
      This is not due to a large download size, but the time it takes for their
      servers to crunch the data. Wrap the function call in \code{httr::with_verbose}
      if you would like to see what's going on.
}
\examples{
\dontrun{
flu <- get_flu_data("hhs", 1:10, c("who", "ilinet"), years=2000:2014)
}
}

