% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opspec.R
\name{rowrecs_to_blocks_spec}
\alias{rowrecs_to_blocks_spec}
\title{Create a row records to block records transform specification.}
\usage{
rowrecs_to_blocks_spec(controlTable, ..., recordKeys = character(0),
  controlTableKeys = colnames(controlTable)[[1]], checkNames = TRUE,
  checkKeys = TRUE, strict = FALSE)
}
\arguments{
\item{controlTable}{an all character data frame or cdata pivot control.}

\item{...}{not used, force later arguments to bind by name.}

\item{recordKeys}{vector of columns identifying records.}

\item{controlTableKeys}{vector of keying columns of the controlTable.}

\item{checkNames}{passed to rowrecs_to_blocks.}

\item{checkKeys}{passed to rowrecs_to_blocks.}

\item{strict}{passed to rowrecs_to_blocks.}
}
\value{
a record specification object
}
\description{
Create a row records to block records transform specification object that holds the pivot control table, specification of
extra row keys, and control table keys.
}
\examples{

d <- wrapr::build_frame(
  "id"  , "AUC", "R2" |
    1   , 0.7  , 0.4  |
    2   , 0.8  , 0.5  )

transform <- rowrecs_to_blocks_spec(
  wrapr::qchar_frame(
    "measure", "value" |
    "AUC"    , AUC     |
    "R2"     , R2      ),
  recordKeys = "id")

print(transform)

d \%.>\% transform

inv_transform <- t(transform)
print(inv_transform)

# identity (in structure)
d \%.>\% transform \%.>\% inv_transform

# identity again (using .() "immediate" notation)
d \%.>\% transform \%.>\% .(t(transform))

}
