% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RowsColumns.R
\name{pivot_to_rowrecs}
\alias{pivot_to_rowrecs}
\title{Move values from rows to columns (pivot).}
\usage{
pivot_to_rowrecs(data, columnToTakeKeysFrom, columnToTakeValuesFrom,
  rowKeyColumns, ..., sep = NULL)
}
\arguments{
\item{data}{data.frame to work with (must be local, for remote please try \code{moveValuesToColumns*}).}

\item{columnToTakeKeysFrom}{character name of column build new column names from.}

\item{columnToTakeValuesFrom}{character name of column to get values from.}

\item{rowKeyColumns}{character array names columns that should be table keys.}

\item{...}{force later arguments to bind by name.}

\item{sep}{character if not null build more detailed column names.}
}
\value{
new data.frame with values moved to columns.
}
\description{
This is a convenience notation for \code{blocks_to_rowrecs}.
For a tutorial please try \code{vignette('RowsAndColumns', package='cdata')}.
}
\examples{

  d <- data.frame(meas= c('AUC', 'R2'), val= c(0.6, 0.2))
  pivot_to_rowrecs(d,
                   columnToTakeKeysFrom= 'meas',
                   columnToTakeValuesFrom= 'val',
                   rowKeyColumns= c()) \%.>\%
     print(.)

}
\seealso{
\code{\link{unpivot_to_blocks}}, \code{\link{blocks_to_rowrecs}}
}
