\docType{package}
\name{cda-package}
\alias{cda-package}
\title{cda}
\description{
Coupled dipole approximation in electromagnetic scattering
}
\details{
Solves the electromagnetic problem of coupled-dipoles
(scattering and absorption by a cluster of subwavelength
particles in arbitrary 3D configuration) by direct
inversion of the interaction matrix. Functions are provided
for linear polarisation with varying angle of incidence, as
well as circular polarisation with angular averaging
(optical activity). Retardation is included in the
interaction.
}
\author{
baptiste Auguie
}
\references{
Draine BT. The discrete-dipole approximation and its
application to interstellar graphite grains. Astrophysical
Journal. 1988.

Schatz GC, Duyne RP. Discrete dipole approximation for
calculating extinction and Raman intensities for small
particles with arbitrary shapes. Journal of Chemical
Physics. 1995.

Gunnarsson L, Zou S, Schatz GC, et al. Confined plasmons in
nanofabricated single silver particle pairs: Experimental
observations of strong interparticle interactions. Journal
of Physical Chemistry B. 2005.

## Any one of the following references should be used to
cite and acknowledge the use of this package.

Circular dichroism:

B. Auguie, J.L. Alonso-Gomez, A. Guerrero-Martinez, L.M.
Liz-Marzan. Fingers crossed: circular dichroism with a
dimer of plasmonic nanorods. J. Phys. Chem. Lett. 2, (2011)

Linear extinction:

B. Auguie, W.L. Barnes. Diffractive coupling in gold
nanoparticle arrays and the effect of disorder. Optics
Letters (2009)

Array factor (infinite case):

B. Auguie, W.L. Barnes. Collective resonances in gold
nanoparticle arrays. Physical Review Letters (2008)
}
\keyword{package}
\keyword{packagelibrary}

