% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getCases.R
\name{getCases}
\alias{getCases}
\title{Execute a SOQL query against the Case object.}
\usage{
getCases(
  confirmedOnly = FALSE,
  from = "1990-01-01",
  to = as.character(Sys.Date()),
  columns = "Id",
  healthUnit = NULL
)
}
\arguments{
\item{confirmedOnly}{Logical scalar. Should the query limit
results to confirmed cases? Returns confirmed and probable cases
by default.}

\item{from}{Character scalar. Identifies the start of the date range
to include in the query. Defaults to the origin date of CCM.}

\item{to}{Character scalar. Identifies the end of the date range
to include in the query. Defaults to \code{Sys.Date()} (i.e. today's date).}

\item{columns}{Character scalar or character vector. Names the columns to
return from the Case object. Defaults to \code{Id}}

\item{healthUnit}{Character vector or scalar. Names the Public Health Unit
used to filter the query. \code{getCases()} filters on Permanent PHU. Defaults
to NULL (i.e. no health unit filter).}
}
\value{
If the query succeeds, a \code{tibble} containing \code{columns}.
}
\description{
\code{getCases()} returns a \code{tibble} of data from the CCM Case object.
The Case object maps to Investigations on the client-side.
}
\examples{
\dontrun{
Get all confirmed cases for Waterloo Region
cases <- getCases(
  confirmedOnly = TRUE,
  healthUnit = 'Durham Region Health Department'
)
Specify the data to return.
cases <- getCases(
  columns = c("Id", "CCM_ReportedDate__c", "CCM_Episode_Date__c", "CCM_Episode_Date_Type__c")
)
Limit the data to a specific time period.
cases <- getCases(
  from = "2020-10-12",
  to = "2020-10-17"
)
}
}
