% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gene_indexer.R
\name{gene_indexer}
\alias{gene_indexer}
\title{Identifies genes annotated to the cell-cycle}
\usage{
gene_indexer(gene_names, species = NULL, name_type = NULL)
}
\arguments{
\item{gene_names}{A vector containing the gene names for the dataset.}

\item{species}{The species which the gene names are from. Either
\code{"human"} or \code{"mouse"}.}

\item{name_type}{The type of gene name considered either, Ensembl gene IDS
(\code{"ensembl"}), offical gene symbols (\code{symbol}), Entrez gene IDS
(\code{"entrez"}), or Unigene IDS (\code{unigene}).}
}
\value{
A vector containg the indices of genes which are annotated to the cell-cycle
}
\description{
Determines which of the genes contained in the dataset are annotated ti the
cell-cycle. This is a preprocessing function for ccRemover. Genes can be
either mouse or human and either official gene symbols, Ensembl, Entrez or
Unigene IDs.
}
\examples{
set.seed(10)
# Load in example data
data(t.cell_data)
head(t.cell_data[,1:5])
# Center example data
t_cell_data_cen <- t(scale(t(t.cell_data), center=TRUE, scale=FALSE))
# Extract gene names
gene_names <- rownames(t_cell_data_cen)
# Determine which genes are annotated to the cell-cycle
cell_cycle_gene_indices <- gene_indexer(gene_names = gene_names,
species = "mouse", name_type = "symbol")
# Create "if_cc" vector
if_cc <- rep(FALSE,nrow(t_cell_data_cen))
if_cc[cell_cycle_gene_indices] <- TRUE

# Can allow the function to automatically detect the name type
cell_cycle_gene_indices <- gene_indexer(gene_names = gene_names,
species = NULL, name_type = NULL)

}
