% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ValeMorelli.r
\name{SolveCorr}
\alias{SolveCorr}
\title{\code{SolveCorr} Solve the Vale-Maurelli cubic equation to find the intermediate correlation between two normal variables that gives rise to a target
 correlation (rho) between the two transformed nonnormal variables.}
\usage{
SolveCorr(rho, coef1, coef2)
}
\arguments{
\item{rho}{desired correlation of transformed variables}

\item{coef1}{vector with coefficents for the Fleishman transform of the first variable}

\item{coef2}{vector with coefficents for the Fleishman transform of the second variable}
}
\value{
root the intermediate correlation
}
\description{
\code{SolveCorr} Solve the Vale-Maurelli cubic equation to find the intermediate correlation between two normal variables that gives rise to a target
 correlation (rho) between the two transformed nonnormal variables.
}
\examples{
rho <- 0.5
coef1<-  c( 0.90475830, 0.14721082, 0.02386092)   
coef2<-  c( 0.90475830, 0.14721082, 0.02386092)   
r <- SolveCorr(rho, coef1, coef2) 

}
