% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ValeMorelli.r
\name{NewtonFl}
\alias{NewtonFl}
\title{\code{NewtonFl} Newton's method to find roots of  the function FlFunc.}
\usage{
NewtonFl(target, startv, maxIter = 100, converge = 1e-12)
}
\arguments{
\item{target}{vector with the desired skewness and kurtosis}

\item{startv}{vector with initial guess of the coefficents for the Fleishman transform}

\item{maxIter}{maximum of iterations}

\item{converge}{limit of allowed absolute error}
}
\value{
out  list with  components                 
       \tabular{ll}{
         coefficients \tab vector with the approximation to the root    \cr
         value \tab vector with differences of root and target  \cr 
         iter \tab number of iterations used   \cr  
         }
}
\description{
\code{NewtonFl} Newton's method to find roots of  the function FlFunc.
}
\examples{
skew <- 1; kurt <- 2
startv <- c( 0.90475830, 0.14721082, 0.02386092)  
out <- NewtonFl(c(skew,kurt),startv) 

}
