% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{gen_hypergeo}
\alias{gen_hypergeo}
\title{Generalized hypergeometric function}
\usage{
gen_hypergeo(U, L, x, tol, max_iter, check_mode, log)
}
\arguments{
\item{U, L}{Numeric vectors for upper and lower values.}

\item{x}{Numeric (1L) as common ratio.}

\item{tol}{Numeric (1L) as convergence tolerance.}

\item{max_iter}{Integer (1L) as iteration limit.}

\item{check_mode}{Logical (1L) indicating whether the mode of \code{x}
should be checked for obvious convergence failures.}

\item{log}{Logical (1L) indicating whether result is given as log(result).}
}
\value{
Result of computation. Warnings are issued if failing to converge.
}
\description{
\code{gen_hypergeo} computes generalized hypergeometric function.
}
\note{
Change log:
\itemize{
\item{0.1.0 Xiurui Zhu - Initiate the function.}
}
}
\examples{
gen_hypergeo(U = c(1.1, 0.2, 0.3), L = c(10.1, 4 * pi), x = 1,
              max_iter = 10000L, tol = 1e-6, check_mode = TRUE, log = FALSE)
}
\author{
Xiurui Zhu
}
