% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cata.R
\encoding{UTF-8}
\name{toMatrix}
\alias{toMatrix}
\title{Converts 3d array of CATA data to a tall 2d matrix format}
\usage{
toMatrix(X, header.rows = TRUE, oneI = FALSE, oneM = FALSE)
}
\arguments{
\item{X}{three-dimensional array (\code{I} assessors, \code{J}
products, \code{M} attributes) where values are \code{0} (not checked) 
or \code{1} (checked)}

\item{header.rows}{\code{TRUE} (default) includes row headers; set to
\code{FALSE} to exclude these headers}

\item{oneI}{indicates whether calculation is for one assessor (default: 
\code{FALSE})}

\item{oneM}{indicates whether calculation is for one attribute (default: 
\code{FALSE})}
}
\value{
A matrix with \code{I} assessors * \code{J} products in rows
and \code{M} attributes in columns (preceded by 2 columns)
of headers if \code{header.rows = TRUE}
}
\description{
Converts a three-dimensional array (\code{I} assessors, \code{J}
products, \code{M} attributes) to a two-dimensional matrix with
(\code{I} assessors, \code{J} products) rows and (\code{M} 
attributes) columns, optionally preceded by two columns of row headers.
}
\examples{
data(bread)

# convert CATA results from the first 8 consumers and the first 4 attributes
# to a tall matrix
toMatrix(bread$cata[1:8,,1:4])
}
