% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CAT_ability_est.R
\name{CAT_ability_est}
\alias{CAT_ability_est}
\title{Ability level estimation using a CAT decision tree}
\usage{
CAT_ability_est(cat.dt, res)
}
\arguments{
\item{cat.dt}{A \code{cat.dt} object returned by \code{\link{CAT_DT}}.}

\item{res}{vector containing the test taker's responses to every item}
}
\value{
A list containing the following elements:

\code{$estimation} Estimated ability level after each level of the tree.

\code{$linf} Lower limit of the final estimation at 95%

\code{$lsup} Upper limit of the final estimation at 95%

\code{$items} Administered item in each level.
}
\description{
Computes the test taker's estimated ability level based on the CAT decision
tree previously built and the test taker's responses to every item at every
tree level
}
\author{
Javier Rodríguez-Cuadrado
}
