% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/responsive.R
\name{responsive}
\alias{responsive}
\title{Understanding responsive arguments}
\description{
Responsive arguments allow you to apply styles to tag elements based on the
size of the viewport (e.g. browser screen). This is important when developing
applications for both web and mobile.  Specifying a single unnamed value the
style will be applied for all viewport sizes. Use the names below to apply a
style for viewports of that size and larger. For example, specifying
\code{c(default = "center", md = "left")} will apply \code{"center"} on extra small and
small viewports, but for medium, large, and extra large viewports \code{"left"} is
applied. Styles for larger viewports take precedence.

A responsive argument may be a single value or a named list. Specifying a
single unnamed value is equivalent to specifying \code{default} or \code{xs}. The
possible values will be described in the specific help page. Most responsive
arguments default to \code{NULL} in which case the argument is ignored.
\subsection{Breakpoints}{

\strong{extra small}

Use the breakpoint with \verb{default =} or \verb{xs = }.

The style is always applied, unless supplanted by a style for any other
breakpoint.

\strong{small}

Use the breakpoint with \verb{sm =}.

The style is applied when the viewport is at least 576px wide, think
landscape phones.

\strong{medium}

Use the breakpoint with \verb{md =}.

The style is applied when the viewport is at least 768px wide, think tablets.

\strong{large}

Use the breakpoint with \verb{lg =}.

The style is applied when the viewport is at least 992px wide, think laptop
or smaller desktops.

\strong{extra large}

Use the breakpoint with \verb{xl =}.

The style is applied when the viewport is at least 1200px wide, think large
desktops.

\strong{extra extra large}

Use the breakpoint with \verb{xxl =}.

The style is applied when the viewport is at least 1400px wide, think large
desktops.
}
}
