% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/material_emissions.R
\name{material_emissions}
\alias{material_emissions}
\title{Material (and waste) emissions}
\usage{
material_emissions(
  glass = 0,
  board = 0,
  mixed = 0,
  paper = 0,
  fridges = 0,
  freezers = 0,
  large_electrical = 0,
  IT = 0,
  small_electrical = 0,
  alkaline_batteries = 0,
  LiIon_batteries = 0,
  NiMh_batteries = 0,
  aluminuim_cans = 0,
  aluminuim_foil = 0,
  mixed_cans = 0,
  scrap = 0,
  steel_cans = 0,
  average = 0,
  average_film = 0,
  average_rigid = 0,
  HDPE = 0,
  LDPE = 0,
  LLDPE = 0,
  PET = 0,
  PP = 0,
  PS = 0,
  PVC = 0,
  glass_WD = 0,
  glass_waste_disposal = c("Closed-loop", "Combustion", "Landfill", "Open-loop"),
  industrial_waste = 0,
  industrial_waste_disposal = c("Combustion", "Landfill"),
  aluminuim_cans_WD = 0,
  aluminuim_foil_WD = 0,
  mixed_cans_WD = 0,
  scrap_WD = 0,
  steel_cans_WD = 0,
  metal_waste_disposal = c("Closed-loop", "Combustion", "Landfill", "Open-loop"),
  board_WD = 0,
  mixed_WD = 0,
  paper_WD = 0,
  paper_waste_disposal = c("Closed-loop", "Combustion", "Composting", "Landfill"),
  average_WD = 0,
  average_film_WD = 0,
  average_rigid_WD = 0,
  HDPE_WD = 0,
  LDPE_WD = 0,
  LLDPE_WD = 0,
  PET_WD = 0,
  PP_WD = 0,
  PS_WD = 0,
  PVC_WD = 0,
  plastic_waste_disposal = c("Closed-loop", "Combustion", "Landfill", "Open-loop"),
  fridges_WD = 0,
  freezers_WD = 0,
  large_electrical_WD = 0,
  IT_WD = 0,
  small_electrical_WD = 0,
  alkaline_batteries_WD = 0,
  LiIon_batteries_WD = 0,
  NiMh_batteries_WD = 0,
  electric_waste_disposal = c("Landfill", "Open-loop"),
  aggregates = 0,
  construction_average = 0,
  asbestos = 0,
  asphalt = 0,
  bricks = 0,
  concrete = 0,
  insulation = 0,
  metals = 0,
  soils = 0,
  mineral_oil = 0,
  plasterboard = 0,
  tyres = 0,
  wood = 0,
  aggregates_WD = 0,
  construction_average_WD = 0,
  asbestos_WD = 0,
  asphalt_WD = 0,
  bricks_WD = 0,
  concrete_WD = 0,
  insulation_WD = 0,
  metals_WD = 0,
  soils_WD = 0,
  mineral_oil_WD = 0,
  plasterboard_WD = 0,
  tyres_WD = 0,
  wood_WD = 0,
  construction_waste_disposal = c("Closed-loop", "Combustion", "Composting", "Landfill",
    "Open-loop"),
  construction_units = c("kg", "tonnes"),
  metal_units = c("kg", "tonnes"),
  glass_units = c("kg", "tonnes"),
  paper_units = c("kg", "tonnes"),
  plastic_units = c("kg", "tonnes"),
  electrical_units = c("kg", "tonnes")
)
}
\arguments{
\item{glass}{Numeric value representing the amount of glass. Default is \code{0}.}

\item{board}{Numeric value indicating the weight of paperboard. Default is \code{0}.}

\item{mixed}{Numeric value indicating the weight of mixed paper. Default is \code{0}.}

\item{paper}{Numeric value indicating the weight of paper. Default is \code{0}.}

\item{fridges}{Numeric value indicating the weight of fridges. Default is \code{0}.}

\item{freezers}{Numeric value indicating the weight of freezers. Default is \code{0}.}

\item{large_electrical}{Numeric value indicating the weight of large electrical items. Default is \code{0}.}

\item{IT}{Numeric value indicating the weight of IT (Information Technology) equipment. Default is \code{0}.}

\item{small_electrical}{Numeric value indicating the weight of small electrical items. Default is \code{0}.}

\item{alkaline_batteries}{Numeric value indicating the weight of alkaline batteries. Default is \code{0}.}

\item{LiIon_batteries}{Numeric value indicating the weight of Lithium-ion batteries. Default is \code{0}.}

\item{NiMh_batteries}{Numeric value indicating the weight of Nickel Metal Hydride batteries. Default is \code{0}.}

\item{aluminuim_cans}{Numeric value indicating the weight of aluminum cans. Default is \code{0}.}

\item{aluminuim_foil}{Numeric value indicating the weight of aluminum foil. Default is \code{0}.}

\item{mixed_cans}{Numeric value indicating the weight of mixed metal cans. Default is \code{0}.}

\item{scrap}{Numeric value indicating the weight of metal scrap. Default is \code{0}.}

\item{steel_cans}{Numeric value indicating the weight of steel cans. Default is \code{0}.}

\item{average}{Numeric value indicating the weight of average plastic. Default is \code{0}.}

\item{average_film}{Numeric value indicating the weight of average film plastic. Default is \code{0}.}

\item{average_rigid}{Numeric value indicating the weight of average rigid plastic. Default is \code{0}.}

\item{HDPE}{Numeric value indicating the weight of HDPE plastic. Default is \code{0}.}

\item{LDPE}{Numeric value indicating the weight of LDPE plastic. Default is \code{0}.}

\item{LLDPE}{Numeric value indicating the weight of LLDPE plastic. Default is \code{0}.}

\item{PET}{Numeric value indicating the weight of PET plastic. Default is \code{0}.}

\item{PP}{Numeric value indicating the weight of PP plastic. Default is \code{0}.}

\item{PS}{Numeric value indicating the weight of PS plastic. Default is \code{0}.}

\item{PVC}{Numeric value indicating the weight of PVC plastic. Default is \code{0}.}

\item{glass_WD}{Numeric value representing the amount of glass waste with disposal. Default is \code{0}.}

\item{glass_waste_disposal}{Character vector specifying the waste disposal method to use for metal for calculating emissions. Possible values: \code{"Closed-loop"}, \code{"Combustion"}, \code{"Landfill"}, \code{"Open-loop"}. Default is "Closed-loop". See \code{details} for more information.}

\item{industrial_waste}{Numeric value representing the amount of household residual waste. Default is \code{0}.}

\item{industrial_waste_disposal}{Character vector specifying the waste disposal method to use for metal for calculating emissions. Possible values: \code{"Combustion"}, \code{"Landfill"}. Default is \code{"Combustion"}. See \code{details} for more information.}

\item{aluminuim_cans_WD}{Numeric value indicating the weight of aluminum cans disposed of using waste disposal methods. Default is \code{0}.}

\item{aluminuim_foil_WD}{Numeric value indicating the weight of aluminum foil disposed of using waste disposal methods. Default is \code{0}.}

\item{mixed_cans_WD}{Numeric value indicating the weight of mixed metal cans disposed of using waste disposal methods. Default is \code{0}.}

\item{scrap_WD}{Numeric value indicating the weight of metal scrap disposed of using waste disposal methods. Default is \code{0}.}

\item{steel_cans_WD}{Numeric value indicating the weight of steel cans disposed of using waste disposal methods. Default is \code{0}.}

\item{metal_waste_disposal}{Character vector specifying the waste disposal method to use for metal for calculating emissions. Possible values: \code{"Closed-loop"}, \code{"Combustion"}, \code{"Landfill"}, \code{"Open-loop"}. Default is "Closed-loop". See \code{details} for more information.}

\item{board_WD}{Numeric value indicating the weight of paperboard disposed of using waste disposal methods. Default is \code{0}.}

\item{mixed_WD}{Numeric value indicating the weight of mixed paper disposed of using waste disposal methods. Default is \code{0}.}

\item{paper_WD}{Numeric value indicating the weight of paper disposed of using waste disposal methods. Default is \code{0}.}

\item{paper_waste_disposal}{Character vector specifying the waste disposal method for paper to use for calculating emissions. Possible values: \code{"Closed-loop"}, \code{"Combustion"}, \code{"Composting"}, \code{"Landfill"}. Default is \code{"Closed-loop"}. See \code{details} for more information.}

\item{average_WD}{Numeric value indicating the weight of average plastic disposed of using waste disposal methods. Default is \code{0}.}

\item{average_film_WD}{Numeric value indicating the weight of average film plastic disposed of using waste disposal methods. Default is \code{0}.}

\item{average_rigid_WD}{Numeric value indicating the weight of average rigid plastic disposed of using waste disposal methods. Default is \code{0}.}

\item{HDPE_WD}{Numeric value indicating the weight of HDPE plastic disposed of using waste disposal methods. Default is \code{0}.}

\item{LDPE_WD}{Numeric value indicating the weight of LDPE plastic disposed of using waste disposal methods. Default is \code{0}.}

\item{LLDPE_WD}{Numeric value indicating the weight of LLDPE plastic disposed of using waste disposal methods. Default is \code{0}.}

\item{PET_WD}{Numeric value indicating the weight of PET plastic disposed of using waste disposal methods. Default is \code{0}.}

\item{PP_WD}{Numeric value indicating the weight of PP plastic disposed of using waste disposal methods. Default is \code{0}.}

\item{PS_WD}{Numeric value indicating the weight of PS plastic disposed of using waste disposal methods. Default is \code{0}.}

\item{PVC_WD}{Numeric value indicating the weight of PVC plastic disposed of using waste disposal methods. Default is \code{0}.}

\item{plastic_waste_disposal}{Character vector specifying the waste disposal method for plastic to use for calculating emissions. Possible values: \code{"Closed-loop"}, \code{"Combustion"}, \code{"Landfill"}, \code{"Open-loop"}. Default is \code{"Closed-loop"}. See \code{details} for more information.}

\item{fridges_WD}{Numeric value indicating the weight of fridges disposed of using waste disposal methods. Default is \code{0}.}

\item{freezers_WD}{Numeric value indicating the weight of freezers disposed of using waste disposal methods. Default is \code{0}.}

\item{large_electrical_WD}{Numeric value indicating the weight of large electrical items disposed of using waste disposal methods. Default is \code{0}.}

\item{IT_WD}{Numeric value indicating the weight of IT equipment disposed of using waste disposal methods. Default is \code{0}.}

\item{small_electrical_WD}{Numeric value indicating the weight of small electrical items disposed of using waste disposal methods. Default is \code{0}.}

\item{alkaline_batteries_WD}{Numeric value indicating the weight of alkaline batteries disposed of using waste disposal methods. Default is \code{0}.}

\item{LiIon_batteries_WD}{Numeric value indicating the weight of Lithium-ion batteries disposed of using waste disposal methods. Default is \code{0}.}

\item{NiMh_batteries_WD}{Numeric value indicating the weight of Nickel Metal Hydride batteries disposed of using waste disposal methods. Default is \code{0}.}

\item{electric_waste_disposal}{Character vector specifying the waste disposal method for electrical items to use for calculating emissions. Possible values: \code{"Landfill"}, \code{"Open-loop"}. Default is \code{"Landfill"}. See \code{details} for more information.}

\item{aggregates}{The weight of aggregates used in construction. Default is \code{0}.}

\item{construction_average}{The weight of average material used in construction. Default is \code{0}.}

\item{asbestos}{The weight of asbestos used in construction. Default is \code{0}.}

\item{asphalt}{The weight of asphalt used in construction. Default is \code{0}.}

\item{bricks}{The weight of bricks used in construction. Default is \code{0}.}

\item{concrete}{The weight of concrete used in construction. Default is \code{0}.}

\item{insulation}{The weight of insulation material used in construction. Default is \code{0}.}

\item{metals}{The weight of metals used in construction. Default is \code{0}.}

\item{soils}{The weight of soils used in construction. Default is \code{0}.}

\item{mineral_oil}{The weight of mineral oil used in construction. Default is \code{0}.}

\item{plasterboard}{The weight of plasterboard used in construction. Default is \code{0}.}

\item{tyres}{The weight of tyres used in construction. Default is \code{0}.}

\item{wood}{The weight of wood used in construction. Default is \code{0}.}

\item{aggregates_WD}{The weight of aggregates disposed of as waste. Default is \code{0}.}

\item{construction_average_WD}{The weight of average material disposed of as waste. Default is \code{0}.}

\item{asbestos_WD}{The weight of asbestos disposed of as waste. Default is \code{0}.}

\item{asphalt_WD}{The weight of asphalt disposed of as waste. Default is \code{0}.}

\item{bricks_WD}{The weight of bricks disposed of as waste. Default is \code{0}.}

\item{concrete_WD}{The weight of concrete disposed of as waste. Default is \code{0}.}

\item{insulation_WD}{The weight of insulation material disposed of as waste. Default is \code{0}.}

\item{metals_WD}{The weight of metals disposed of as waste. Default is \code{0}.}

\item{soils_WD}{The weight of soils disposed of as waste. Default is \code{0}.}

\item{mineral_oil_WD}{The weight of mineral oil disposed of as waste. Default is \code{0}.}

\item{plasterboard_WD}{The weight of plasterboard disposed of as waste. Default is \code{0}.}

\item{tyres_WD}{The weight of tyres disposed of as waste. Default is \code{0}.}

\item{wood_WD}{The weight of wood disposed of as waste. Default is \code{0}.}

\item{construction_waste_disposal}{Character vector specifying the waste disposal method for electrical items to use for calculating emissions. Options are, \code{"Closed-loop"}, \code{"Combustion"}, \code{"Composting"}, \code{"Landfill"},
\code{"Open-loop"}. Default is \code{"Closed-loop"}.
Note that: \code{"Closed-loop"} is valid for aggregates, average, asphalt, concrete, insulation,
metal, soils, mineral oil, plasterboard, tyres, and wood.
\code{"Combustion"} is valid for average, mineral oil, and wood.
\code{"Composting"} is valid for wood only.
\code{"Landfill"} is valid for everything except average, mineral oil, and tyres.
\code{"Open-loop"} is valid for aggregates, average, asphalt, bricks, concrete,
If one of these is used for a value that does not provide it, then an \code{"NA"} is given.}

\item{construction_units}{Character vector specifying the units of the emissions related to construction. Possible values: \code{"kg"}, \code{"tonnes"}. Default is \code{"kg"}.}

\item{metal_units}{Character vector specifying the units of the emissions  related to metal. Possible values: \code{"kg"}, \code{"tonnes"}. Default is \code{"kg"}.}

\item{glass_units}{Character vector specifying the units of the emissions related to glass. Possible values: \code{"kg"}, \code{"tonnes"}. Default is \code{"kg"}.}

\item{paper_units}{Character vector specifying the units of the emissions related to paper. Possible values: \code{"kg"}, \code{"tonnes"}. Default is \code{"kg"}.}

\item{plastic_units}{Character vector specifying the units of the emissions related to plastic materials. Possible values: \code{"kg"}, \code{"tonnes"}. Default is \code{"kg"}.}

\item{electrical_units}{Character vector specifying the units of the emissions related to electrical materials. Possible values: \code{"kg"}, \code{"tonnes"}. Default is \code{"kg"}.}
}
\value{
The calculated household emissions as a numeric value in tonnes.
}
\description{
Material (and waste) emissions
}
\details{
\verb{*_waste_disposal} methods:
\code{"Open-loop"} is the process of recycling material into other products.
\code{"Closed-loop"} is the process of recycling material back into the same product.
\code{"Combustion"} energy is recovered from the waste through incineration and subsequent generation of electricity.
\code{"Compost"} CO2e emitted as a result of composting a waste stream.
\code{"Landfill"} the product goes to landfill after use.
\code{"Anaerobic digestion"} energy is recovered from the waste through anaerobic digestion.
}
\examples{
\donttest{
  material_emissions(glass = 100, glass_WD = 10, glass_units = "kg")
}
}
