% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/household_emissions.R
\name{household_emissions}
\alias{household_emissions}
\title{Calculate household material emissions}
\usage{
household_emissions(
  glass = 0,
  clothing = 0,
  food = 0,
  drink = 0,
  compost_from_garden = 0,
  compost_from_food_and_garden = 0,
  board = 0,
  mixed = 0,
  paper = 0,
  fridges = 0,
  freezers = 0,
  large_electrical = 0,
  IT = 0,
  small_electrical = 0,
  alkaline_batteries = 0,
  LiIon_batteries = 0,
  NiMh_batteries = 0,
  aluminuim_cans = 0,
  aluminuim_foil = 0,
  mixed_cans = 0,
  scrap = 0,
  steel_cans = 0,
  average = 0,
  average_film = 0,
  average_rigid = 0,
  HDPE = 0,
  LDPE = 0,
  LLDPE = 0,
  PET = 0,
  PP = 0,
  PS = 0,
  PVC = 0,
  glass_WD = 0,
  books_WD = 0,
  clothing_WD = 0,
  gcb_waste_disposal = c("Closed-loop", "Combustion", "Landfill"),
  household_residual_waste = 0,
  hh_waste_disposal = c("Combustion", "Landfill"),
  food_WD = 0,
  drink_WD = 0,
  compost_from_garden_WD = 0,
  compost_from_food_and_garden_WD = 0,
  compost_waste_disposal = c("Anaerobic digestion", "Combustion", "Composting",
    "Landfill"),
  aluminuim_cans_WD = 0,
  aluminuim_foil_WD = 0,
  mixed_cans_WD = 0,
  scrap_WD = 0,
  steel_cans_WD = 0,
  metal_waste_disposal = c("Closed-loop", "Combustion", "Landfill", "Open-loop"),
  board_WD = 0,
  mixed_WD = 0,
  paper_WD = 0,
  paper_waste_disposal = c("Closed-loop", "Combustion", "Composting", "Landfill"),
  average_WD = 0,
  average_film_WD = 0,
  average_rigid_WD = 0,
  HDPE_WD = 0,
  LDPE_WD = 0,
  LLDPE_WD = 0,
  PET_WD = 0,
  PP_WD = 0,
  PS_WD = 0,
  PVC_WD = 0,
  plastic_waste_disposal = c("Closed-loop", "Combustion", "Landfill", "Open-loop"),
  fridges_WD = 0,
  freezers_WD = 0,
  large_electrical_WD = 0,
  IT_WD = 0,
  small_electrical_WD = 0,
  alkaline_batteries_WD = 0,
  LiIon_batteries_WD = 0,
  NiMh_batteries_WD = 0,
  electric_waste_disposal = c("Landfill", "Open-loop"),
  units = c("kg", "tonnes")
)
}
\arguments{
\item{glass}{Numeric value representing the amount of glass. Default is \code{0}.}

\item{clothing}{Numeric value representing the amount of clothing. Default is \code{0}.}

\item{food}{Numeric value representing the amount of food. Default is \code{0}.}

\item{drink}{Numeric value representing the amount of drink. Default is \code{0}.}

\item{compost_from_garden}{Numeric value representing the amount of compost from garden waste. Default is \code{0}.}

\item{compost_from_food_and_garden}{Numeric value representing the amount of compost from food and garden waste. Default is \code{0}.}

\item{board}{Numeric value indicating the weight of paperboard. Default is \code{0}.}

\item{mixed}{Numeric value indicating the weight of mixed paper. Default is \code{0}.}

\item{paper}{Numeric value indicating the weight of paper. Default is \code{0}.}

\item{fridges}{Numeric value indicating the weight of fridges. Default is \code{0}.}

\item{freezers}{Numeric value indicating the weight of freezers. Default is \code{0}.}

\item{large_electrical}{Numeric value indicating the weight of large electrical items. Default is \code{0}.}

\item{IT}{Numeric value indicating the weight of IT (Information Technology) equipment. Default is \code{0}.}

\item{small_electrical}{Numeric value indicating the weight of small electrical items. Default is \code{0}.}

\item{alkaline_batteries}{Numeric value indicating the weight of alkaline batteries. Default is \code{0}.}

\item{LiIon_batteries}{Numeric value indicating the weight of Lithium-ion batteries. Default is \code{0}.}

\item{NiMh_batteries}{Numeric value indicating the weight of Nickel Metal Hydride batteries. Default is \code{0}.}

\item{aluminuim_cans}{Numeric value indicating the weight of aluminum cans. Default is \code{0}.}

\item{aluminuim_foil}{Numeric value indicating the weight of aluminum foil. Default is \code{0}.}

\item{mixed_cans}{Numeric value indicating the weight of mixed metal cans. Default is \code{0}.}

\item{scrap}{Numeric value indicating the weight of metal scrap. Default is \code{0}.}

\item{steel_cans}{Numeric value indicating the weight of steel cans. Default is \code{0}.}

\item{average}{Numeric value indicating the weight of average plastic. Default is \code{0}.}

\item{average_film}{Numeric value indicating the weight of average film plastic. Default is \code{0}.}

\item{average_rigid}{Numeric value indicating the weight of average rigid plastic. Default is \code{0}.}

\item{HDPE}{Numeric value indicating the weight of HDPE plastic. Default is \code{0}.}

\item{LDPE}{Numeric value indicating the weight of LDPE plastic. Default is \code{0}.}

\item{LLDPE}{Numeric value indicating the weight of LLDPE plastic. Default is \code{0}.}

\item{PET}{Numeric value indicating the weight of PET plastic. Default is \code{0}.}

\item{PP}{Numeric value indicating the weight of PP plastic. Default is \code{0}.}

\item{PS}{Numeric value indicating the weight of PS plastic. Default is \code{0}.}

\item{PVC}{Numeric value indicating the weight of PVC plastic. Default is \code{0}.}

\item{glass_WD}{Numeric value representing the amount of glass waste with disposal. Default is \code{0}.}

\item{books_WD}{Numeric value representing the amount of books waste with disposal. Default is \code{0}.}

\item{clothing_WD}{Numeric value representing the amount of clothing waste with disposal. Default is \code{0}.}

\item{gcb_waste_disposal}{Character value specifying the waste disposal method for glass, clothing, and books waste (options: \code{"Closed-loop"}, \code{"Combustion"}, \code{"Landfill"}). Default is \code{"Closed-loop"}. See \code{details} for more information.}

\item{household_residual_waste}{Numeric value representing the amount of household residual waste. Default is \code{0}.}

\item{hh_waste_disposal}{Character value specifying the waste disposal method for  waste (options: \code{"Combustion"}, \code{"Landfill"}). Default is \code{"Combustion"}. See \code{details} for more information.}

\item{food_WD}{Numeric value indicating the weight of food disposed of using waste disposal methods. Default is \code{0}.}

\item{drink_WD}{Numeric value indicating the weight of drink disposed of using waste disposal methods. Default is \code{0}.}

\item{compost_from_garden_WD}{Numeric value indicating the weight of compost from garden waste disposed of using waste disposal methods. Default is \code{0}.}

\item{compost_from_food_and_garden_WD}{Numeric value indicating the weight of compost from garden and food waste disposed of using waste disposal methods. Default is \code{0}.}

\item{compost_waste_disposal}{Character value specifying the waste disposal method for compost waste (options: \code{"Anaerobic digestion"}, \code{"Combustion"}, \code{"Composting"}, \code{"Landfill"}). Default is \code{"Anaerobic digestion"}. See \code{details} for more information.}

\item{aluminuim_cans_WD}{Numeric value indicating the weight of aluminum cans disposed of using waste disposal methods. Default is \code{0}.}

\item{aluminuim_foil_WD}{Numeric value indicating the weight of aluminum foil disposed of using waste disposal methods. Default is \code{0}.}

\item{mixed_cans_WD}{Numeric value indicating the weight of mixed metal cans disposed of using waste disposal methods. Default is \code{0}.}

\item{scrap_WD}{Numeric value indicating the weight of metal scrap disposed of using waste disposal methods. Default is \code{0}.}

\item{steel_cans_WD}{Numeric value indicating the weight of steel cans disposed of using waste disposal methods. Default is \code{0}.}

\item{metal_waste_disposal}{Character vector specifying the waste disposal method to use for metal for calculating emissions. Possible values: "Closed-loop", "Combustion", "Landfill", "Open-loop". Default is "Closed-loop". See \code{details} for more information.}

\item{board_WD}{Numeric value indicating the weight of paperboard disposed of using waste disposal methods. Default is \code{0}.}

\item{mixed_WD}{Numeric value indicating the weight of mixed paper disposed of using waste disposal methods. Default is \code{0}.}

\item{paper_WD}{Numeric value indicating the weight of paper disposed of using waste disposal methods. Default is \code{0}.}

\item{paper_waste_disposal}{Character vector specifying the waste disposal method for paper to use for calculating emissions. Possible values: \code{"Closed-loop"}, \code{"Combustion"}, \code{"Composting"}, \code{"Landfill"}. Default is \code{"Closed-loop"}. See \code{details} for more information.}

\item{average_WD}{Numeric value indicating the weight of average plastic disposed of using waste disposal methods. Default is \code{0}.}

\item{average_film_WD}{Numeric value indicating the weight of average film plastic disposed of using waste disposal methods. Default is \code{0}.}

\item{average_rigid_WD}{Numeric value indicating the weight of average rigid plastic disposed of using waste disposal methods. Default is \code{0}.}

\item{HDPE_WD}{Numeric value indicating the weight of HDPE plastic disposed of using waste disposal methods. Default is \code{0}.}

\item{LDPE_WD}{Numeric value indicating the weight of LDPE plastic disposed of using waste disposal methods. Default is \code{0}.}

\item{LLDPE_WD}{Numeric value indicating the weight of LLDPE plastic disposed of using waste disposal methods. Default is \code{0}.}

\item{PET_WD}{Numeric value indicating the weight of PET plastic disposed of using waste disposal methods. Default is \code{0}.}

\item{PP_WD}{Numeric value indicating the weight of PP plastic disposed of using waste disposal methods. Default is \code{0}.}

\item{PS_WD}{Numeric value indicating the weight of PS plastic disposed of using waste disposal methods. Default is \code{0}.}

\item{PVC_WD}{Numeric value indicating the weight of PVC plastic disposed of using waste disposal methods. Default is \code{0}.}

\item{plastic_waste_disposal}{Character vector specifying the waste disposal method for plastic to use for calculating emissions. Possible values: \code{"Closed-loop"}, \code{"Combustion"}, \code{"Landfill"}, \code{"Open-loop"}. Default is \code{"Closed-loop"}. See \code{details} for more information.}

\item{fridges_WD}{Numeric value indicating the weight of fridges disposed of using waste disposal methods. Default is \code{0}.}

\item{freezers_WD}{Numeric value indicating the weight of freezers disposed of using waste disposal methods. Default is \code{0}.}

\item{large_electrical_WD}{Numeric value indicating the weight of large electrical items disposed of using waste disposal methods. Default is \code{0}.}

\item{IT_WD}{Numeric value indicating the weight of IT equipment disposed of using waste disposal methods. Default is \code{0}.}

\item{small_electrical_WD}{Numeric value indicating the weight of small electrical items disposed of using waste disposal methods. Default is \code{0}.}

\item{alkaline_batteries_WD}{Numeric value indicating the weight of alkaline batteries disposed of using waste disposal methods. Default is \code{0}.}

\item{LiIon_batteries_WD}{Numeric value indicating the weight of Lithium-ion batteries disposed of using waste disposal methods. Default is \code{0}.}

\item{NiMh_batteries_WD}{Numeric value indicating the weight of Nickel Metal Hydride batteries disposed of using waste disposal methods. Default is \code{0}.}

\item{electric_waste_disposal}{Character vector specifying the waste disposal method for electrical items to use for calculating emissions. Possible values: \code{"Landfill"}, \code{"Open-loop"}. Default is \code{"Landfill"}. See \code{details} for more information.}

\item{units}{Character vector specifying the units of the emissions output. Possible values: \code{"kg"}, \code{"tonnes"}. Default is \code{"kg"}.}
}
\value{
The calculated household emissions as a numeric value in tonnes.
}
\description{
Calculate household material emissions
}
\details{
\verb{*_waste_disposal} methods:
\code{"Open-loop"} is the process of recycling material into other products.
\code{"Closed-loop"} is the process of recycling material back into the same product.
\code{"Combustion"} energy is recovered from the waste through incineration and subsequent generation of electricity.
\code{"Compost"} CO2e emitted as a result of composting a waste stream.
\code{"Landfill"} the product goes to landfill after use.
\code{"Anaerobic digestion"} energy is recovered from the waste through anaerobic digestion.
}
\examples{
household_emissions(glass = 100, clothing = 10, glass_WD = 10, units = "kg")
}
