% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fenegbin.R
\name{fenegbin}
\alias{fenegbin}
\title{Negative Binomial model fitting with high-dimensional k-way fixed
effects}
\usage{
fenegbin(
  formula = NULL,
  data = NULL,
  weights = NULL,
  beta_start = NULL,
  eta_start = NULL,
  init_theta = NULL,
  link = c("log", "identity", "sqrt"),
  control = NULL
)
}
\arguments{
\item{formula}{an object of class \code{"formula"}: a symbolic description of
the model to be fitted. \code{formula} must be of type \code{y ~ x | k},
where the second part of the formula refers to factors to be concentrated
out. It is also possible to pass clustering variables to \code{\link{feglm}}
as \code{y ~ x | k | c}.}

\item{data}{an object of class \code{"data.frame"} containing the variables
in the model. The expected input is a dataset with the variables specified
in \code{formula} and a number of rows at least equal to the number of
variables in the model.}

\item{weights}{an optional string with the name of the 'prior weights'
variable in \code{data}.}

\item{beta_start}{an optional vector of starting values for the structural
parameters in the linear predictor. Default is
\eqn{\boldsymbol{\beta} = \mathbf{0}}{\beta = 0}.}

\item{eta_start}{an optional vector of starting values for the linear
predictor.}

\item{init_theta}{an optional initial value for the theta parameter (see
\code{\link[MASS]{glm.nb}}).}

\item{link}{the link function. Must be one of \code{"log"}, \code{"sqrt"}, or
\code{"identity"}.}

\item{control}{a named list of parameters for controlling the fitting
process. See \code{\link{feglm_control}} for details.}
}
\value{
A named list of class \code{"feglm"}. The list contains the following
eighteen elements:
\item{coefficients}{a named vector of the estimated coefficients}
\item{eta}{a vector of the linear predictor}
\item{weights}{a vector of the weights used in the estimation}
\item{hessian}{a matrix with the numerical second derivatives}
\item{deviance}{the deviance of the model}
\item{null_deviance}{the null deviance of the model}
\item{conv}{a logical indicating whether the model converged}
\item{iter}{the number of iterations needed to converge}
\item{theta}{the estimated theta parameter}
\item{iter.outer}{the number of outer iterations}
\item{conv.outer}{a logical indicating whether the outer loop converged}
\item{nobs}{a named vector with the number of observations used in the
estimation indicating the dropped and perfectly predicted observations}
\item{lvls_k}{a named vector with the number of levels in each fixed
effects}
\item{nms_fe}{a list with the names of the fixed effects variables}
\item{formula}{the formula used in the model}
\item{data}{the data used in the model after dropping non-contributing
observations}
\item{family}{the family used in the model}
\item{control}{the control list used in the model}
}
\description{
A routine that uses the same internals as \code{\link{feglm}}.
}
\examples{
# check the feglm examples for the details about clustered standard errors
mod <- fenegbin(mpg ~ wt | cyl, mtcars)
summary(mod)

}
