% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/bump.R
\name{bump}
\alias{bump}
\title{Captioner bump function}
\usage{
bump(cap_fun, level)
}
\arguments{
\item{cap_fun}{The captioner function that needs to be bumped}

\item{level}{Numeric indicating which sub-number should be incremented}
}
\value{
None.
}
\description{
For figure numbers with sub-values (e.g. 1.1), increment one of the sub-values for use in
the next figure.
}
\details{
Normally captioner only increments the final number in your figure number, even if you have
hierarchical numbering (e.g. Fig 1.1.1).  This function will bump up any of the penultimate
numbers of your choice using a given index.  You can use it at the start of a section, for example,
to shift from Fig 1.5 to Fig 2.1.
}
\examples{
figs <- captioner(levels = 2)
figs("a")

bump(figs, 1)
}
\seealso{
\code{\link{captioner}}
}

