% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cansim_sql.R
\name{remove_cansim_sqlite_cached_table}
\alias{remove_cansim_sqlite_cached_table}
\title{Remove cached cansim SQLite database}
\usage{
remove_cansim_sqlite_cached_table(
  cansimTableNumber,
  language = NULL,
  cache_path = getOption("cansim.cache_path")
)
}
\arguments{
\item{cansimTableNumber}{Number of the table to be removed}

\item{language}{Language for which to remove the cached data. If unspecified (`NULL`) tables for all languages
will be removed}

\item{cache_path}{Optional, default value is `getOption("cansim.cache_path")`}
}
\value{
`NULL``
}
\description{
Remove cached cansim SQLite database
}
\examples{
\dontrun{
con <- get_cansim_connection("34-10-0013", format="sqlite")
disconnect_cansim_sqlite(con)
remove_cansim_cached_tables("34-10-0013", format="sqlite")
}
}
\keyword{internal}
