% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cansim_tables_list.R
\name{list_cansim_cubes}
\alias{list_cansim_cubes}
\title{Get overview list for all Statistics Canada data cubes}
\usage{
list_cansim_cubes(lite = FALSE, refresh = FALSE)
}
\arguments{
\item{lite}{Get the version without cube dimensions and comments for faster retrieval, default is \code{FALSE}.}

\item{refresh}{Default is \code{FALSE}, repeated calls during the same session will hit the cached data.
To refresh the code list during a running R session set to \code{TRUE}}
}
\value{
A tibble with available Statistics Canada data cubes, including NDM table number, cube title,
start and end dates, achieve status, subject and survey codes, frequency codes and a list of cube dimensions.
}
\description{
Generates an overview table containing metadata of available Statistics Canada data cubes.
}
\examples{
\dontrun{
list_cansim_cubes()
}

}
