\encoding{UTF-8}
\name{xsummary}
\alias{xsummary}
\alias{xsummary2}
\alias{xsummary3}
\title{Summarize Chemical Differences}
\description{
  Make an HTML table summarizing chemical differences.
}

\usage{
  xsummary(comptab, vars = c("ZC", "nH2O"))
  xsummary2(comptab1, comptab2)
  xsummary3(comptab1, comptab2, comptab3)
}

\arguments{
  \item{comptab}{list or data frame, summary of comparisons generated by \code{\link{get_comptab}}}
  \item{vars}{character, two variables to tabulate}
  \item{comptab1}{list, output of \code{get_comptab}}
  \item{comptab2}{list, output of \code{get_comptab}}
  \item{comptab3}{list, output of \code{get_comptab}}
}

\details{
\code{xsummary} makes an HTML table (using \code{\link[xtable]{xtable}}) and adds bold and underline formatting to highlight significant chemical differences.
The \emph{p}-value is bolded if it is less than 0.05, and the percent common language effect size (\code{\link{CLES}}) is bolded if it is <= 40 or >= 60.
The mean (or median) difference is [underlined / bolded] if [only one of / both] the \emph{p}-value and CLES pass these cutoffs.

The generated table is written to the console, and can be used in a vignette using the \code{results = "asis"} chunk option.
The function also returns (invisibly) the data frame used to make the table; this data frame differs from \code{comptab} by having row names added (alphabetical one-letter IDs for the datasets).

\code{xsummary2} is an updated version that is used in the current vignettes in the package.
It shows negative numbers in bold (\emph{p}-value and CLES are not shown).
\code{xsummary3} is a further revision that shows GRAVY and pI; it is used in the \samp{osmotic_bact} and \samp{osmotic_halo} vignettes.
}

\examples{
comptab <- lapply(c("JKMF10", "WDO+15_C.N"), function(dataset) {
  pdat <- pdat_colorectal(dataset)
  get_comptab(pdat, oldstyle = TRUE)
})
xsummary(comptab)
}

\concept{Vignette utilities}
