% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mask_crop_subset.R
\name{mask_crop_subset}
\alias{mask_crop_subset}
\title{mask_crop_subset}
\usage{
mask_crop_subset(r, p, idx = NULL, ...)
}
\arguments{
\item{r}{Raster* object}

\item{p}{SpatialPolygon* object}

\item{idx}{vector of strings indicating the layer indices to subset.}

\item{...}{additional arguments as in writeRaster
(e.g. \code{progress = "text"})}
}
\value{
A Raster* object with resolution and land-sea mask matching those of
\code{r} and extent matching \code{p}.
}
\description{
mask and/or crop a Raster* based on a Polygon.
}
\details{
Please note that cells along the border with centroids falling
outside the polygon \code{p} will not be returned.
If cells along the border are needed, we suggest to identify cells covering
the polygon and set all remaining pixels to NA, as described in this post:
\url{https://goo.gl/22LwJt}.
}
\examples{
\dontrun{

  # Define dummy polygon
  shape <- as(raster::extent(7, 18, 37, 40), "SpatialPolygons")
  
  # Read RISICO test data
  r_risico <- readRDS(system.file("extdata", "RISICO_raster.rds",
                                  package = "caliver"))
  
  mask_crop_subset(r = r_risico, p = shape)

}

}
