% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calib_pv.R
\name{calc_pv_aj}
\alias{calc_pv_aj}
\title{Estimate pseudo-values for the transition probabilities based on the Aalen-Johansen estimator}
\usage{
calc_pv_aj(person_id.eval, data.mstate, obs.aj, tmat, n.cohort, t, j)
}
\arguments{
\item{person_id.eval}{id of individual to calculate the pseudo-value for}

\item{data.mstate}{Validation data in \code{msdata} format}

\item{obs.aj}{Aalen-Johansen estimator of the transition probabilities in the entire cohort (not excluding person_id.eval)}

\item{tmat}{Transition probability matrix}

\item{n.cohort}{Size of cohort (number of unique entries in data.mstate)}

\item{t}{Follow up time at which calibration is to be assessed}

\item{j}{Landmark state at which predictions were made}
}
\description{
Estimates the pseudo-values for an individual (person_id.eval) from cohort data.mstate.
Calculates psuedo-values for transition probabilities at time t if in state j at time 0
The Aalen-Johansen estimator for the entire cohort (including individual person_id.eval)
is inputted manually (obs.aj), to speed up computaitonal time if calculating pseudo-values
for multiple individuals from the same cohort.
}
