% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hermite.R
\name{hermite}
\alias{hermite}
\title{Hermite Polynomials}
\usage{
hermite(order, sigma = 1, var = "x", transform = NULL)
}
\arguments{
\item{order}{the order of the Hermite polynomial.}

\item{sigma}{the covariance \code{matrix} of the Gaussian kernel.}

\item{var}{\code{character} vector giving the variables of the polynomial.}

\item{transform}{\code{character} vector representing a change of variables. See details.}
}
\value{
\code{list} of Hermite polynomials with components:
\describe{
 \item{f}{the Hermite polynomial.}
 \item{order}{the order of the Hermite polynomial.}
 \item{terms}{\code{data.frame} containing the variables, coefficients and degrees of each term in the Hermite polynomial.}
}
}
\description{
Computes univariate and multivariate Hermite polynomials.
}
\details{
Hermite polynomials are obtained by differentiation of the Gaussian kernel:

\deqn{H_{\nu}(x,\Sigma) = exp \Bigl( \frac{1}{2} x_i \Sigma_{ij} x_j \Bigl) (- \partial_x )^\nu exp \Bigl( -\frac{1}{2} x_i \Sigma_{ij} x_j \Bigl)}

where \eqn{\Sigma} is a \eqn{d}-dimensional square matrix and 
\eqn{\nu=(\nu_1 \dots \nu_d)} is the vector representing the order of 
differentiation for each variable \eqn{x = (x_1\dots x_d)}. 
In the case where \eqn{\Sigma=1} and \eqn{x=x_1} the formula reduces to the 
standard univariate Hermite polynomials:

\deqn{H_{\nu}(x) = e^{\frac{x^2}{2}}(-1)^\nu \frac{d^\nu}{dx^\nu}e^{-\frac{x^2}{2}}}

If \code{transform} is not \code{NULL}, the variables \code{var} \eqn{x} are replaced with
\code{transform} \eqn{f(x)} to compute the polynomials \eqn{H_{\nu}(f(x),\Sigma)}
}
\examples{
### univariate Hermite polynomials up to order 3
hermite(3)

### multivariate Hermite polynomials up to order 2
hermite(order = 2, 
        sigma = matrix(c(1,0,0,1), nrow = 2), 
        var = c('z1', 'z2'))
        
### multivariate Hermite polynomials with transformation of variables
hermite(order = 2, 
        sigma = matrix(c(1,0,0,1), nrow = 2), 
        var = c('z1', 'z2'),
        transform = c('z1+z2','z1-z2'))
        
}
\references{
Guidotti, E. (2020). "calculus: High dimensional numerical and symbolic calculus in R". \url{https://arxiv.org/abs/2101.00086}
}
\seealso{
Other polynomials: 
\code{\link{taylor}()}
}
\concept{polynomials}
