% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/taylor.R
\name{taylor}
\alias{taylor}
\title{Taylor Series}
\usage{
taylor(f, var = "x", order = 1, accuracy = 2, stepsize = NULL)
}
\arguments{
\item{f}{function, expression or character}

\item{var}{character. The variables of \code{f}.}

\item{order}{the order of the Taylor approximation.}

\item{accuracy}{accuracy degree for numerical derivatives.}

\item{stepsize}{finite differences stepsize for numerical derivatives. Auto-optimized by default.}
}
\value{
list with components
\describe{
 \item{f}{the Taylor series.}
 \item{order}{the approximation order.}
 \item{terms}{data.frame containing the variables, coefficients and degrees of each term in the Taylor series.}
}
}
\description{
Computes the Taylor series for functions, expressions or characters.
}
\examples{
# univariate taylor series 
taylor('exp(x)', var = 'x', order = 3)

# univariate taylor series of arbitrary functions
taylor(function(x) exp(x), var = 'x', order = 3)

# multivariate taylor series 
taylor('sin(x*y)', var = c('x','y'), order = 6)

# multivariate taylor series of arbitrary functions
taylor(function(x,y) sin(x*y), var = c('x','y'), order = 6)

}
