% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mixed_adaptive_test_function.R
\name{mixed_adaptive_test}
\alias{mixed_adaptive_test}
\title{Mixed Computerized Adaptive Multistage Test}
\usage{
mixed_adaptive_test(
  response_matrix,
  cat_item_bank,
  initial_theta = 0,
  method = "BM",
  item_method = "MFI",
  cat_length,
  nAvailable_cat = NULL,
  cbControl = NULL,
  cbGroup = NULL,
  randomesque = 1,
  mst_item_bank,
  modules,
  transition_matrix,
  n_stages
)
}
\arguments{
\item{response_matrix}{A matrix of the person responses, with individuals as rows and items as columns.}

\item{cat_item_bank}{A data frame with the first stage items on the rows and their item parameters on the columns. These should be in the \pkg{mstR} package format for item banks.}

\item{initial_theta}{The initial theta estimate for all individuals.}

\item{method}{A character value indicating method for the provisional theta estimate. Defaults to "BM" (Bayes Modal). See the \pkg{catR} and \pkg{mstR} packages for more details.}

\item{item_method}{A character value indicating the method for the item-level selection in the first stage. Defaults to "MFI" (Maximum Fisher Information). See the \pkg{catR} and \pkg{mstR} packages for more details.}

\item{cat_length}{A numeric value indicating the number of items in the first stage.}

\item{nAvailable_cat}{Defaults to `NULL`. See the \pkg{catR} package for more information on how to use this option.}

\item{cbControl}{A list of the appropriate format used to control for content balancing in the first stage. See the Details in the nextItem function in \pkg{catR}.}

\item{cbGroup}{A factor vector of the appropriate format used to control for content balancing in the first stage. See the Details in the nextItem function in \pkg{catR}.}

\item{randomesque}{An integer indicating the number of items from which to select the next item to administer in the first stage. Default value is 1.}

\item{mst_item_bank}{A data frame with the second stage and beyond items on the rows and their item parameters on the columns. These should be in the \pkg{mstR} package format for item banks.}

\item{modules}{A matrix describing the relationship between the items and the modules they belong to. See \strong{Details}.}

\item{transition_matrix}{A matrix describing how individuals can transition from one stage to the next.}

\item{n_stages}{A numerical value indicating the number of stages in the test.}
}
\value{
A list of all individuals with the following elements: the vector of final theta estimates based on "method", the vector of final theta estimates based on EAP, the vector of final theta estimates based on the iterative estimate from Baker 2004, a matrix of the final items taken, a matrix of the modules seen, and a matrix of the final responses.

An S4 object of class 'MST' with the following slots:
\item{function.call}{The function and arguments called to create this object.}
\item{final.theta.estimate}{A numeric vector of the final theta estimates using the \code{method} provided in \code{function.call}.}
\item{eap.theta}{A numeric vector of the final theta estimates using the expected a posteriori (EAP) theta estimate from \code{catR::eapEst}.}
\item{final.theta.Baker}{A numeric vector of the final theta estimates using an iterative maximum likelihood estimation procedure as described in chapter 5 of Baker (2001).}
\item{final.theta.SEM}{A numeric vector of the final standard error of measurement (SEM) estimates using an iterative maximum likelihood estimation procedure as described in chapter 5 of Baker (2001).}
\item{final.items.seen}{A matrix of the final items seen by each individual using the supplied item names. `NA` values indicate that an individual wasn't given any items to answer after the last specified item in their row.}
\item{final.responses}{A matrix of the responses to the items seen in \code{final.items.seen}. \code{NA} values indicate that the individual didn't answer the question in the supplied response file or wasn't given any more items to answer.}
\item{transition.matrix}{The \code{transition_matrix} originally supplied to the function.}
\item{n.stages}{The \code{n_stages} originally supplied to the function.}
\item{runtime}{A \code{difftime} object recording how long the function took to complete.}
}
\description{
Mixed Computerized Adaptive Multistage Test
}
\details{
To be filled in later.
}
\examples{
\donttest{
# using simulated test data
data(example_thetas) # 5 simulated abilities
data(example_responses) # 5 simulated response vectors
# the transition matrix for an 18 item 1-3-3 balanced design
data(example_transition_matrix)
# the items designated for use in the routing module with item-level
# adaptation
data(cat_items)
# the items designated for use in the second and third modules with
# module-level adaptation
data(mst_items)
# the matrix specifying how the item data frame relates to the modules
data(example_module_items)

# run the Mca-MST model
results <- mixed_adaptive_test(response_matrix = example_responses[1:2,],
                               cat_item_bank = cat_items, initial_theta = 0,
                               method = "EAP", item_method = "MFI",
                               cat_length = 6, cbControl = NULL, cbGroup = NULL,
                               randomesque = 1, mst_item_bank = mst_items,
                               modules = example_module_items,
                               transition_matrix = example_transition_matrix,
                               n_stages = 3)
}

}
\references{
Baker (2001). http://echo.edres.org:8080/irt/baker/final.pdf
}
\seealso{
[multistage_test] for a standard multistage test, [computerized_adaptive_test] for a standard computerized adaptive test.
}
