% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper_test_MGD.R
\name{getParameterNames}
\alias{getParameterNames}
\title{Internal: Parameter names}
\usage{
getParameterNames(
           .object  = args_default()$.object,
           .model   = args_default()$.model
  )
}
\arguments{
\item{.object}{An R object of class \link{cSEMResults} resulting from a call to \code{\link[=csem]{csem()}}.}

\item{.model}{A model in \link[lavaan:model.syntax]{lavaan model syntax} indicating which
parameters (i.e, path (\code{~}), loadings (\verb{=~}), or weights (\verb{<~})) should be
compared across groups. Defaults to \code{NULL} in which case all parameters of the model
are compared.}
}
\value{
A list with elements \code{names_path}, \code{names_loadings}, and \code{names_weights}
containing the names of the structural parameters, the loadings,
and the weight to compare across groups.
}
\description{
Based on a model in \link[lavaan:model.syntax]{lavaan model syntax}, returns the
names of the parameters of the structural
model, the measurement/composite model and the weight relationship. Used
by \code{\link[=testMGD]{testMGD()}} to extract the names of the parameters to compare across groups
according to the test proposed by \insertCite{Chin2010;textual}{cSEM}.
}
\references{
\insertAllCited{}
}
\keyword{internal}
