% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper_assess.R
\name{reliability}
\alias{reliability}
\alias{calculateRhoC}
\alias{calculateRhoT}
\title{Internal: Reliability}
\usage{
calculateRhoC(
  .object = NULL,
  .model_implied = FALSE,
  .only_common_factors = TRUE,
  .weighted = args_default()$.weighted
)

calculateRhoT(
  .object = NULL,
  .alpha = args_default()$.alpha,
  .closed_form_ci = args_default()$.closed_form_ci,
  .only_common_factors = TRUE,
  .output_type = c("vector", "data.frame"),
  .weighted = args_default()$.weighted,
  ...
)
}
\arguments{
\item{.object}{An R object of class \link{cSEMResults} resulting from a call to \code{\link[=csem]{csem()}}.}

\item{.model_implied}{Logical. Should the RMS_theta be computed using the
model-implied construct correlation matrix (\code{TRUE}) or the construct correlation matrix
based on V(eta) = WSW' divided by the square root of the respective
reliabilities (\code{FALSE}). Defaults to \code{FALSE}.}

\item{.only_common_factors}{Logical. Should only concepts modeled as common
factors be included when calculating one of the following quality critera:
AVE, the Fornell-Larcker criterion, HTMT, and all reliability estimates.
Defaults to \code{TRUE}.}

\item{.weighted}{Logical. Should estimation be based on a score that uses
the weights of the weight approach used to obtain \code{.object}?. Defaults to \code{FALSE}.}

\item{.alpha}{An integer or a numeric vector of significance levels.
Defaults to \code{0.05}.}

\item{.closed_form_ci}{Logical. Should a closed-form confidence interval be computed?
Defaults to \code{FALSE}.}

\item{.output_type}{Character string. The type of output. One of "vector" or
"data.frame". Defaults to "vector".}

\item{...}{Ignored.}
}
\value{
For \code{calculateRhoC()} and \code{calculateRhoT()} (if \code{.output_type = "vector"})
a named numeric vector containing the reliability estimates.
If \code{.output_type = "data.frame"} \code{calculateRhoT()} returns a \code{data.frame} with as many rows as there are
constructs modeled as common factors in the model (unless
\code{.only_common_factors = FALSE} in which case the number of rows equals the
total number of constructs in the model). The first column contains the name of the construct.
The second column the reliability estimate.
If \code{.closed_form_ci = TRUE} the remaining columns contain lower and upper bounds
for the (1 - \code{.alpha}) confidence interval(s).
}
\description{
Compute several reliability estimates. See the
\href{https://m-e-rademaker.github.io/cSEM/articles/Using-assess.html#reliability}{Reliability}
section of the \href{https://m-e-rademaker.github.io/cSEM/index.html}{cSEM website}
for details.
}
\details{
Since reliability is defined with respect to a classical true score measurement
model only concepts modeled as common factors are considered by default.
For concepts modeled as composites reliability may be estimated by setting
\code{.only_common_factors = FALSE}, however, it is unclear how to
interpret reliability in this case.

Reliability is traditionally based on a test score (proxy) based on unit weights.
To compute congeneric and tau-equivalent reliability based on a score that
uses the weights of the weight approach used to obtain \code{.object} use \code{.weighted = TRUE}
instead.

For the tau-equivalent reliability ("\code{rho_T}" or "\code{cronbachs_alpha}") a closed-form
confidence interval may be computed \insertCite{Trinchera2018}{cSEM} by setting
\code{.closed_form_ci = TRUE} (default is \code{FALSE}). If \code{.alpha} is a vector
several CI's are returned.

The function is only applicable to objects inheriting class \code{cSEMResults_default}.
For objects of class \code{cSEMResults_multi} and \code{cSEMResults_2ndorder} use \code{\link[=assess]{assess()}}.
}
\section{Functions}{
\itemize{
\item \code{calculateRhoC}: Calculate the congeneric reliability, also known as
composite reliability or rho_A.

\item \code{calculateRhoT}: Calculate the tau-equivalent reliability, also known
as Cronbach's alpha or coefficient alpha. Since
indicators are always standarized in \code{cSEM},
tau-equivalent reliability is identical to the
parallel reliability.
}}

\references{
\insertAllCited{}
}
\seealso{
\code{\link[=assess]{assess()}}, \link{cSEMResults}
}
\keyword{internal}
