% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper_assess.R
\name{distance_measures}
\alias{distance_measures}
\alias{calculateDG}
\alias{calculateDL}
\alias{calculateDML}
\title{Internal: Calculate difference between S and Sigma_hat}
\usage{
calculateDG(
  .object = NULL,
  .matrix1 = NULL,
  .matrix2 = NULL,
  .saturated = args_default()$.saturated,
  ...
)

calculateDL(
  .object = NULL,
  .matrix1 = NULL,
  .matrix2 = NULL,
  .saturated = args_default()$.saturated,
  ...
)

calculateDML(.object = NULL, .saturated = args_default()$.saturated, ...)
}
\arguments{
\item{.object}{An R object of class \link{cSEMResults} resulting from a call to \code{\link[=csem]{csem()}}.}

\item{.matrix1}{A \code{matrix} to compare.}

\item{.matrix2}{A \code{matrix} to compare.}

\item{.saturated}{Logical. Should a saturated structural model be used?
Defaults to \code{FALSE}.}

\item{...}{Ignored.}
}
\value{
A single numeric value giving the distance between two matrices.
}
\description{
Calculate the difference between the empirical (S)
and the model-implied indicator variance-covariance matrix (Sigma_hat)
using different distance measures.
}
\details{
The functions are only applicable to objects inheriting class \code{cSEMResults_default}.
or \code{cSEMResults_2ndorder}. For objects of class \code{cSEMResults_multi}
use \code{lapply(.object, calculateXX())}.

The geodesic and the squared Euclidian distance may also be
computed for any two matrices A and B by supplying A and B directly via the
\code{.matrix1} and \code{.matrix2} arguments. If A and B are supplied \code{.object} is ignored.
}
\section{Functions}{
\itemize{
\item \code{calculateDG}: The geodesic distance (dG).

\item \code{calculateDL}: The squared Euclidian distance

\item \code{calculateDML}: The distance measure used by FIML
}}

\keyword{internal}
